/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.exchange;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.gds.flyArystan.FlyArystanGdsAccount;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanReissueHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanWsRequestParams;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.reissue.AmountType;
import com.hititcs.crane.ws.reissue.BasicRequestType;
import com.hititcs.crane.ws.reissue.BookingReferenceIDType;
import com.hititcs.crane.ws.reissue.CompanyNameType;
import com.hititcs.crane.ws.reissue.CurrencyType;
import com.hititcs.crane.ws.reissue.FullfillmentType;
import com.hititcs.crane.ws.reissue.MiscChargeOrderType;
import com.hititcs.crane.ws.reissue.PaymentDetailType;
import com.hititcs.crane.ws.reissue.PaymentDetailsType;
import com.hititcs.crane.ws.reissue.PaymentTypeCodesType;
import com.hititcs.crane.ws.reissue.ReissuePnrOtaModifyRequestType;
import com.hititcs.crane.ws.reissue.ReissuePnrSegments;
import com.hititcs.crane.ws.reissue.UniqueIDType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;

public class ReissuePnrCommitRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.EXCHANGE_SELECTED_FLIGHT);
        ReissuePnrOtaModifyRequestType request = new ReissuePnrOtaModifyRequestType();
        BookingReferenceIDType bookingReferenceIDType = new BookingReferenceIDType();
        UniqueIDType recordLocator = FlyArystanReissueHelper.buildBookingReferenceId(reservation);
        CompanyNameType companyNameType = new CompanyNameType();
        ReissuePnrSegments oldSegment = new ReissuePnrSegments();
        ReissuePnrSegments newSegment = new ReissuePnrSegments();
        Product product = (Product)GDSHelper.getAllEffectiveProducts((Reservation)reservation).get(0);
        BigDecimal totalEquivalentFareProducts = BigDecimal.ZERO;
        for (Product prod : GDSHelper.getAllEffectiveProducts((Reservation)reservation)) {
            totalEquivalentFareProducts = totalEquivalentFareProducts.add(AirProductHelper.getTotalEquivalentFare((Product)prod));
        }
        ArrayList bookFlightSegmentTypeNewList = new ArrayList();
        FlightHelper.getFlightLegs((Flight)flight).stream().forEach(segFlightList -> segFlightList.stream().forEach(flightSegment -> bookFlightSegmentTypeNewList.add(FlyArystanReissueHelper.buildBookFlightNewSegment(flightSegment, segFlightList.indexOf(flightSegment)))));
        newSegment.getBookFlightSegment().addAll(bookFlightSegmentTypeNewList);
        ArrayList bookFlightSegmentTypeOldList = new ArrayList();
        AtomicInteger segInd = new AtomicInteger();
        AirProductHelper.getSegments((Collection)product.getSegmentTariffs()).stream().forEach(segment -> bookFlightSegmentTypeOldList.add(FlyArystanReissueHelper.buildBookFlightOldSegment(segment, segInd.getAndIncrement())));
        oldSegment.getBookFlightSegment().addAll(bookFlightSegmentTypeOldList);
        bookingReferenceIDType.setID(recordLocator != null ? recordLocator.getID() : null);
        bookingReferenceIDType.setReferenceID(recordLocator != null ? recordLocator.getReferenceID() : null);
        companyNameType.setCode(product.getCarrier().getCode());
        bookingReferenceIDType.setCompanyName(companyNameType);
        request.setFullfillment(this.buildFullFillmentType((FlyArystanGdsAccount)accountCtr.getEntity(), reservation, flight, totalEquivalentFareProducts));
        request.setBookingReferenceID(bookingReferenceIDType);
        request.setOldSegments(oldSegment);
        request.setNewSegments(newSegment);
        ctx.putObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_REQUEST_PARAMS, (Object)new FlyArystanWsRequestParams("reissuePnrCommit", (BasicRequestType)request));
    }

    private FullfillmentType buildFullFillmentType(FlyArystanGdsAccount account, Reservation reservation, Flight flight, BigDecimal totalEquivalentFareProducts) {
        FullfillmentType fullfillmentType = new FullfillmentType();
        PaymentDetailsType pds = new PaymentDetailsType();
        PaymentDetailType pd = new PaymentDetailType();
        pd.setPrimaryPayment(true);
        pd.setPaymentAmount(this.buildPaymentAmount(this.getGdsCurrency(reservation), flight, totalEquivalentFareProducts));
        pd.setPaymentType(PaymentTypeCodesType.MISC_CHARGE_ORDER);
        MiscChargeOrderType mco = new MiscChargeOrderType();
        mco.setPaymentCode("INV");
        mco.setMCONumber(account.getInvoiceNumber());
        pd.setMiscChargeOrder(mco);
        pds.getPaymentDetailList().add(pd);
        fullfillmentType.setPaymentDetails(pds);
        return fullfillmentType;
    }

    private AmountType buildPaymentAmount(String currency, Flight flight, BigDecimal totalEquivalentFareProducts) {
        AmountType result = new AmountType();
        result.setValue(Double.valueOf(String.valueOf(FlightHelper.getEquivalentFareAndTaxesTotal((Flight)flight).add(FlightHelper.getEquivalentPenaltiesTotal((Flight)flight)).subtract(totalEquivalentFareProducts))).doubleValue());
        CurrencyType ct = new CurrencyType();
        ct.setCode(currency);
        result.setCurrency(ct);
        return result;
    }

    private String getGdsCurrency(Reservation reservation) {
        Product firstProduct = (Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0);
        return firstProduct.getGdsCurrency();
    }
}

