/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.exchange;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.ExchangeParameters;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.GDSRepriceHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanReissueHelper;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.reissue.AirBookingResponseType;
import com.hititcs.crane.ws.reissue.AirBookingType;
import com.hititcs.crane.ws.reissue.AirReservationType;
import com.hititcs.crane.ws.reissue.AirTravelerType;
import com.hititcs.crane.ws.reissue.BookFlightSegmentType;
import com.hititcs.crane.ws.reissue.BookOriginDestinationOptionType;
import com.hititcs.crane.ws.reissue.FlightSegmentType;
import com.hititcs.crane.ws.reissue.TicketItemType;
import com.hititcs.crane.ws.reissue.TicketType;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;

public class ReissuePnrCommitRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        AirBookingResponseType response = (AirBookingResponseType)ctx.getMandatoryObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_RESPONSE);
        ExchangeParameters exchangeParams = (ExchangeParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.EXCHANGE_PARAMS);
        List airBookings = response.getAirBookingList();
        AirBookingType airBooking = (AirBookingType)airBookings.get(0);
        AirReservationType airReservation = airBooking.getAirReservation();
        String currency = airReservation.getArrangerInfo().getCurrency();
        Date now = new Date();
        Product productTemplate = this.buildTemplateProduct(airReservation, now);
        ArrayList<Message> messages = new ArrayList<Message>();
        for (String productUid : exchangeParams.getProductUids()) {
            Product mainProduct = BookingStreamHelper.getProductsStream((Reservation)reservation, Product.class).filter(p -> p.getUid().equals(productUid)).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find product with uid {0}", (Object[])new Object[]{productUid}));
            Traveller traveller = mainProduct.getTraveller();
            List<TicketItemType> ticketItems = this.findTicketItems(airBooking, traveller);
            TicketItemType mainTicketItem = ticketItems.stream().filter(ti -> ti.getType() == TicketType.E_TICKET).filter(ti -> MiscUtil.equals((Object)FlyArystanHelper.getSystemNumber(ti.getIssuedInExchangeFor()), (Object)mainProduct.getSystemNumber())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find reservation system ticketItem for traveller", (Object[])new Object[0]));
            Product product = this.buildProduct(productTemplate, mainProduct.getTraveller(), currency, mainTicketItem, messages);
            AirProductHelper.setSubagency((Product)product, (EntityReference)AirProductHelper.getSubagency((Product)mainProduct));
            AirProductHelper.setAgency((Product)product, (EntityReference)AirProductHelper.getAgency((Product)mainProduct));
            AirProductHelper.setSupplier((Product)product, (EntityReference)AirProductHelper.getSupplier((Product)mainProduct));
            BookingHelper.addProduct((Reservation)reservation, (BaseProduct)product);
            Product exchange = AirProductHelper.clone((Product)mainProduct, (boolean)true);
            exchange.setStatus(ProductStatus.EXCHANGE);
            exchange.setContractRulesApplied(false);
            exchange.setChecked(false);
            mainProduct.setNextProduct(exchange);
            exchange.setPreviousProduct(mainProduct);
            exchange.setNextProduct(product);
            product.setPreviousProduct(exchange);
        }
    }

    private Product buildProduct(Product productTemplate, Traveller traveller, String currency, TicketItemType ticketItem, List<Message> messages) throws Exception {
        AirTravelerType airTraveler = ticketItem.getAirTraveler();
        Product product = (Product)XCloneHelper.clone((XCloneable)productTemplate, (boolean)true);
        product.setGdsId(FlyArystanReissueHelper.buildGdsId(ticketItem));
        product.setTravellerGdsId(airTraveler.getTravelerReferenceID());
        product.setGdsCurrency(currency);
        ProductHandler.of((BaseProduct)product).setOrReplaceTraveller((BaseProduct)product, traveller);
        ((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().removeIf(seg -> !ticketItem.getCouponInfoList().stream().anyMatch(ci -> MiscUtil.equals((Object)seg.getGdsId(), (Object)FlyArystanReissueHelper.getGdsSegmentId(ci))));
        product.setPassengerType(FlyArystanReissueHelper.convertPassengerTypeFromGds(airTraveler.getPassengerTypeCode()));
        product.setProviderSystemNumber(ticketItem.getOriginalTicketNumber());
        product.setConjCount(ticketItem.getConjunctiveTicketList().size() - 1);
        GDSRepriceHelper.updateAndCheckProductPrices((Product)product, prod -> {
            FlyArystanReissueHelper.updateProduct(prod, ticketItem);
            prod.setTotalVendorEquivalentVatAmount(null);
        }, messages);
        FlyArystanReissueHelper.updateProduct(product, ticketItem);
        FlyArystanHelper.updateTicketNumber(product, ticketItem.getTicketDocumentNbr());
        return product;
    }

    private Product buildTemplateProduct(AirReservationType airReservation, Date now) {
        Product productTemplate = new Product();
        productTemplate.setTicketType(com.gridnine.xtrip.common.model.booking.TicketType.OWN);
        productTemplate.setStatus(ProductStatus.SELL);
        productTemplate.setTariffType(TariffType.REGULAR);
        productTemplate.setEticket(true);
        productTemplate.setIssueDate(now);
        productTemplate.setProductCategory(ProductCategory.AIR);
        SegmentTariff segmentTariff = new SegmentTariff();
        for (BookOriginDestinationOptionType bookOriginDestination : airReservation.getAirItinerary().getBookOriginDestinationOptions().getBookOriginDestinationOptionList()) {
            boolean isStarting = true;
            for (BookFlightSegmentType bookFlightSegment : bookOriginDestination.getBookFlightSegmentList()) {
                segmentTariff.getSegments().add(this.buildSegment(bookFlightSegment, isStarting));
                isStarting = false;
            }
        }
        productTemplate.getSegmentTariffs().add(segmentTariff);
        FlyArystanHelper.setCarrier(productTemplate);
        return productTemplate;
    }

    private Segment buildSegment(BookFlightSegmentType bookingSeg, boolean isStarting) {
        FlightSegmentType gdsSeg = bookingSeg.getFlightSegment();
        Segment result = new Segment();
        result.setGdsId(FlyArystanReissueHelper.getGdsSegmentId(bookingSeg));
        result.setStarting(isStarting);
        result.setAirline(FlyArystanHelper.resolveNativeCode(Airline.class, gdsSeg.getAirline().getCode()));
        result.setFlightNo(gdsSeg.getFlightNumber());
        if (gdsSeg.getOperatingAirline() != null) {
            result.setCodeShareCarrier(FlyArystanHelper.resolveNativeCode(Airline.class, gdsSeg.getOperatingAirline().getCode()));
            if (result.getAirline() != null) {
                result.setCodeShare(!result.getAirline().equals((Object)result.getCodeShareCarrier()));
            }
        } else {
            result.setCodeShareCarrier(result.getAirline());
        }
        result.setDepartureLocation(FlyArystanHelper.resolveNativeCode(GeoLocation.class, gdsSeg.getDepartureAirport().getLocationCode()));
        result.setDepartTerminal(gdsSeg.getDepartureAirport().getTerminal());
        result.setArriveLocation(FlyArystanHelper.resolveNativeCode(GeoLocation.class, gdsSeg.getArrivalAirport().getLocationCode()));
        result.setArriveTerminal(gdsSeg.getArrivalAirport().getTerminal());
        result.setStartDate(MiscUtil.toDateWithoutTimeZone((XMLGregorianCalendar)gdsSeg.getDepartureDateTime()));
        result.setEndDate(MiscUtil.toDateWithoutTimeZone((XMLGregorianCalendar)gdsSeg.getArrivalDateTime()));
        result.setBoard(FlyArystanHelper.resolveNativeCode(Aircraft.class, gdsSeg.getEquipment().getAirEquipType()));
        result.setFlightDuration(Integer.valueOf((int)Duration.parse(gdsSeg.getJourneyDuration()).toMinutes()));
        result.setClassOfSvcCode(bookingSeg.getFareInfo().getResBookDesigCode());
        result.setNotValidBefore(result.getStartDate());
        result.setNotValidAfter(result.getEndDate());
        return result;
    }

    private List<TicketItemType> findTicketItems(AirBookingType airBooking, Traveller traveller) {
        return airBooking.getTicketInfo().getTicketItemList().stream().filter(ti -> this.isSameTraveller(traveller, ti.getAirTraveler())).collect(Collectors.toList());
    }

    private boolean isSameTraveller(Traveller traveller, AirTravelerType gdsTraveler) {
        if (gdsTraveler == null) {
            return false;
        }
        Passport passport = traveller.getPassport();
        if (!MiscUtil.equals((Object)passport.getBirthday(), (Object)MiscUtil.clearTime((Date)MiscUtil.toDateWithoutTimeZone((XMLGregorianCalendar)gdsTraveler.getBirthDate())))) {
            return false;
        }
        if (!MiscUtil.equals((Object)passport.getLastName().toUpperCase(), (Object)gdsTraveler.getPersonName().getSurname())) {
            return false;
        }
        return MiscUtil.equals((Object)passport.getFirstName().toUpperCase(), (Object)gdsTraveler.getPersonName().getGivenName());
    }
}

