/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.exchange;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightPenalty;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanReissueHelper;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.reissue.AirBookingResponseType;
import com.hititcs.crane.ws.reissue.AirBookingType;
import com.hititcs.crane.ws.reissue.PenaltyType;
import com.hititcs.crane.ws.reissue.TicketInfoType;
import com.hititcs.crane.ws.reissue.TicketItemType;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ReissuePnrPreviewRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.EXCHANGE_SELECTED_FLIGHT);
        AirBookingResponseType response = (AirBookingResponseType)ctx.getMandatoryObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_RESPONSE);
        for (DictionaryReference pt : GDSHelper.seatPreferencesToMap((List)flight.getSeats()).keySet()) {
            TicketItemType ticketItem = response.getAirBookingList().stream().map(AirBookingType::getTicketInfo).map(TicketInfoType::getTicketItemList).flatMap(Collection::stream).filter(ti -> MiscUtil.equals((Object)pt, FlyArystanReissueHelper.convertPassengerTypeFromGds(ti.getAirTraveler().getPassengerTypeCode()))).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find ticketItem with passengerType {0}", (Object[])new Object[]{pt}));
            flight.getExchangeData().getPenalties().addAll(this.getPenalties(ticketItem));
        }
        ctx.putObject((Enum)IBusGdsContextKeys.EXCHANGE_SELECTED_FLIGHT, (Object)flight);
    }

    private Collection<FlightPenalty> getPenalties(TicketItemType ticketItem) {
        DictionaryReference<PassengerType> pt = FlyArystanReissueHelper.convertPassengerTypeFromGds(ticketItem.getAirTraveler().getPassengerTypeCode());
        return ticketItem.getPricingInfo().getPenaltyList().stream().map(penalty -> this.buildFlightPenalty((PenaltyType)penalty, pt)).collect(Collectors.toList());
    }

    private FlightPenalty buildFlightPenalty(PenaltyType penalty, DictionaryReference<PassengerType> pt) {
        FlightPenalty flightPenalty = new FlightPenalty();
        flightPenalty.setEquivalentAmount(FlyArystanReissueHelper.toBigDecimal(penalty.getAmount()));
        flightPenalty.setPassengerType(pt);
        return flightPenalty;
    }
}

