/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.expandReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeReservationParameters;
import com.gridnine.xtrip.common.gds.model.GdsExpandReservationParameters;
import com.gridnine.xtrip.common.gds.model.GdsExpandReservationTraveller;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanAncHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanWsRequestParams;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.ancillary.AncillaryOtaModifyRequestType;
import com.hititcs.crane.ws.ancillary.AncillaryRequestType;
import com.hititcs.crane.ws.ancillary.BasicRequestType;

public class FlyArystanAddSsrRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        GdsExpandReservationParameters params = (GdsExpandReservationParameters)ctx.getObject((Enum)IBusMidofficeContextKeys.EXPAND_RESERVATION_PARAMETERS);
        ctx.putObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_REQUEST_PARAMS, (Object)new FlyArystanWsRequestParams("addSsr", (BasicRequestType)this.buildRequest(reservation, params)));
    }

    private AncillaryOtaModifyRequestType buildRequest(Reservation reservation, GdsExpandReservationParameters params) {
        AncillaryOtaModifyRequestType result = new AncillaryOtaModifyRequestType();
        result.setBookingReferenceID(FlyArystanAncHelper.buildBookingReferenceId(reservation));
        Product firstProduct = (Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0);
        result.setAirItinerary(FlyArystanAncHelper.buildAirItinerary(firstProduct));
        int travellerInd = 1;
        for (GdsExpandReservationTraveller expandTraveller : params.getExpandTravellers()) {
            Traveller traveller = (Traveller)CollectionUtil.find((Iterable)reservation.getBookingFile().getTravellers(), (String)expandTraveller.getTravellerUid());
            result.getAirTravelerList().add(FlyArystanAncHelper.buildGdsTraveller(reservation, traveller));
            for (AncillaryFeeReservationParameters ancillaryFee : expandTraveller.getAncillaryFees()) {
                for (int i = 0; i < ancillaryFee.getQuantity(); ++i) {
                    result.getAncillaryRequestList().add(this.buildAncillaryRequest(ancillaryFee, travellerInd));
                }
            }
            ++travellerInd;
        }
        return result;
    }

    private AncillaryRequestType buildAncillaryRequest(AncillaryFeeReservationParameters ancillaryFee, int travellerInd) {
        AncillaryRequestType result = new AncillaryRequestType();
        result.setAirTravelerSequence(travellerInd);
        Integer segNumber = FlyArystanAncHelper.getAncillaryFeeSegNumber(ancillaryFee.getGdsId());
        result.setFlightSegmentSequence(segNumber + 1);
        result.setSsrCode(FlyArystanAncHelper.getAncillaryFeeSsrCode(ancillaryFee.getGdsId()));
        result.setSsrGroup(FlyArystanAncHelper.getAncillaryFeeSsrGroup(ancillaryFee.getGdsId()));
        return result;
    }
}

