/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.expandReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescription;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanAncHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.ancillary.AirBookingResponseType;
import com.hititcs.crane.ws.ancillary.AirBookingType;
import com.hititcs.crane.ws.ancillary.AirReservationType;
import com.hititcs.crane.ws.ancillary.AirTaxType;
import com.hititcs.crane.ws.ancillary.AirTravelerType;
import com.hititcs.crane.ws.ancillary.AmountType;
import com.hititcs.crane.ws.ancillary.BookFlightSegmentType;
import com.hititcs.crane.ws.ancillary.BookOriginDestinationOptionType;
import com.hititcs.crane.ws.ancillary.CouponInfoType;
import com.hititcs.crane.ws.ancillary.FareInfoType;
import com.hititcs.crane.ws.ancillary.FlightSegmentType;
import com.hititcs.crane.ws.ancillary.SsrType;
import com.hititcs.crane.ws.ancillary.TaxesType;
import com.hititcs.crane.ws.ancillary.TicketItemType;
import com.hititcs.crane.ws.ancillary.TicketType;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

public class FlyArystanAddSsrResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        AirBookingResponseType response = (AirBookingResponseType)ctx.getMandatoryObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_RESPONSE);
        this.updateReservation(reservation, response);
    }

    private void updateReservation(Reservation reservation, AirBookingResponseType response) throws Exception {
        List airBookings = response.getAirBookingList();
        if (airBookings.size() != 1) {
            throw Xeption.forDeveloper((String)"unsupported AirBookingList size: {0}", (Object[])new Object[]{airBookings.size()});
        }
        AirBookingType airBooking = (AirBookingType)airBookings.get(0);
        AirReservationType airReservation = airBooking.getAirReservation();
        List bookingReferenceIDs = airReservation.getBookingReferenceIDList();
        if (bookingReferenceIDs.size() != 1) {
            throw Xeption.forDeveloper((String)"unsupported BookingReferenceIDList size: {0}", (Object[])new Object[]{bookingReferenceIDs.size()});
        }
        Product productTemplate = this.buildTemplateProduct(airReservation);
        boolean mcoAdded = false;
        for (TicketItemType ticketItem : airBooking.getTicketInfo().getTicketItemList()) {
            String gdsId;
            if (ticketItem.getType() != TicketType.MCO || GDSHelper.findProductByGdsId((Reservation)reservation, (String)(gdsId = FlyArystanAncHelper.buildGdsId(ticketItem))) != null) continue;
            String travelerGdsId = ticketItem.getAirTraveler().getTravelerReferenceID();
            Product mainProduct = GDSHelper.findProductByTravellerGdsId((Reservation)reservation, (String)travelerGdsId, (ProductCategory)ProductCategory.AIR);
            if (mainProduct == null) {
                throw Xeption.forDeveloper((String)"can't find main product for travelerGdsId {0}", (Object[])new Object[]{travelerGdsId});
            }
            Product product = this.buildMcoProduct(mainProduct, productTemplate, ticketItem, gdsId);
            BookingHelper.addProduct((Reservation)reservation, (BaseProduct)product);
            mcoAdded = true;
        }
        if (!mcoAdded) {
            throw Xeption.forDeveloper((String)"mco wasn't added to reservation {0}", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)});
        }
    }

    private Product buildTemplateProduct(AirReservationType airReservation) {
        Product productTemplate = new Product();
        productTemplate.setTicketType(com.gridnine.xtrip.common.model.booking.TicketType.OWN);
        productTemplate.setStatus(ProductStatus.BOOKING);
        productTemplate.setTariffType(TariffType.REGULAR);
        productTemplate.setEticket(true);
        productTemplate.setIssueDate(new Date());
        SegmentTariff segmentTariff = new SegmentTariff();
        for (BookOriginDestinationOptionType bookOriginDestination : airReservation.getAirItinerary().getBookOriginDestinationOptions().getBookOriginDestinationOptionList()) {
            boolean isStarting = true;
            for (BookFlightSegmentType bookFlightSegment : bookOriginDestination.getBookFlightSegmentList()) {
                segmentTariff.getSegments().add(this.buildSegment(bookFlightSegment, isStarting));
                isStarting = false;
            }
        }
        productTemplate.getSegmentTariffs().add(segmentTariff);
        FlyArystanHelper.setCarrier(productTemplate);
        return productTemplate;
    }

    private Segment buildSegment(BookFlightSegmentType bookingSeg, boolean isStarting) {
        FlightSegmentType gdsSeg = bookingSeg.getFlightSegment();
        Segment result = new Segment();
        result.setGdsId(FlyArystanAncHelper.getGdsSegmentId(bookingSeg));
        result.setStarting(isStarting);
        result.setAirline(FlyArystanHelper.resolveNativeCode(Airline.class, gdsSeg.getAirline().getCode()));
        result.setFlightNo(gdsSeg.getFlightNumber());
        if (gdsSeg.getOperatingAirline() != null) {
            result.setCodeShareCarrier(FlyArystanHelper.resolveNativeCode(Airline.class, gdsSeg.getOperatingAirline().getCode()));
            if (result.getAirline() != null) {
                result.setCodeShare(!result.getAirline().equals((Object)result.getCodeShareCarrier()));
            }
        } else {
            result.setCodeShareCarrier(result.getAirline());
        }
        result.setDepartureLocation(FlyArystanHelper.resolveNativeCode(GeoLocation.class, gdsSeg.getDepartureAirport().getLocationCode()));
        result.setDepartTerminal(gdsSeg.getDepartureAirport().getTerminal());
        result.setArriveLocation(FlyArystanHelper.resolveNativeCode(GeoLocation.class, gdsSeg.getArrivalAirport().getLocationCode()));
        result.setArriveTerminal(gdsSeg.getArrivalAirport().getTerminal());
        result.setStartDate(MiscUtil.toDateWithoutTimeZone((XMLGregorianCalendar)gdsSeg.getDepartureDateTime()));
        result.setEndDate(MiscUtil.toDateWithoutTimeZone((XMLGregorianCalendar)gdsSeg.getArrivalDateTime()));
        result.setBoard(FlyArystanHelper.resolveNativeCode(Aircraft.class, gdsSeg.getEquipment().getAirEquipType()));
        result.setFlightDuration(Integer.valueOf((int)Duration.parse(gdsSeg.getJourneyDuration()).toMinutes()));
        result.setClassOfSvcCode(bookingSeg.getFareInfo().getResBookDesigCode());
        result.setNotValidBefore(result.getStartDate());
        result.setNotValidAfter(result.getEndDate());
        return result;
    }

    private Product buildMcoProduct(Product mainProduct, Product productTemplate, TicketItemType ticketItem, String gdsId) throws Exception {
        AirTravelerType airTraveler = ticketItem.getAirTraveler();
        Product product = (Product)XCloneHelper.clone((XCloneable)productTemplate, (boolean)true);
        product.setGdsId(gdsId);
        product.setTravellerGdsId(airTraveler.getTravelerReferenceID());
        product.setGdsCurrency(mainProduct.getGdsCurrency());
        ProductHandler.of((BaseProduct)product).setOrReplaceTraveller((BaseProduct)product, mainProduct.getTraveller());
        ((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().removeIf(seg -> !ticketItem.getCouponInfoList().stream().anyMatch(ci -> MiscUtil.equals((Object)seg.getGdsId(), (Object)FlyArystanAncHelper.getGdsSegmentId(ci))));
        product.setPassengerType(FlyArystanAncHelper.convertPassengerTypeFromGds(airTraveler.getPassengerTypeCode()));
        FlyArystanAddSsrResponseParser.updateProduct(product, ticketItem);
        product.setProductCategory(ProductCategory.MCO);
        SsrType ssr = ticketItem.getSpecialServiceRequest();
        MiscUtil.Pair<AncillaryFeeType, AncillaryFeeDescription> afPair = FlyArystanHelper.getAncillaryFeeTypeDescription(ssr.getGroupCode(), ssr.getCode());
        AncillaryFeeType ancillaryFeeType = (AncillaryFeeType)afPair.getFirst();
        AncillaryFeeDescription ancillaryFeeDescription = (AncillaryFeeDescription)afPair.getSecond();
        product.setMcoCategory(GdsDictHelper.convertToMcoCategory((AncillaryFeeType)ancillaryFeeType));
        product.setAncillaryFeeDescription(DictHelper.toReference((BaseDictionary)ancillaryFeeDescription));
        if (ticketItem.getReasonForIssuance() != null) {
            product.setGdsDescription(ticketItem.getReasonForIssuance().getExplanation());
        }
        product.setMcoCancellationAllowed(true);
        product.getRelatedProducts().add(mainProduct);
        String actionCode = ((CouponInfoType)ticketItem.getCouponInfoList().get(0)).getCouponFlightSegment().getActionCode();
        product.setMcoReservationRequestStatus(FlyArystanHelper.getMcoReservationRequestStatus(actionCode));
        return product;
    }

    public static void updateProduct(Product product, TicketItemType ticketItem) {
        product.setFareCalculationData(ticketItem.getFareConstruction());
        product.getFares().clear();
        product.getTaxes().clear();
        product.getFares().add(FlyArystanAddSsrResponseParser.createProductFare(ticketItem.getPricingInfo().getEquivBaseFare()));
        product.getTaxes().addAll(FlyArystanAddSsrResponseParser.buildTaxes(ticketItem.getPricingInfo().getTaxes()));
        for (Segment seg : AirProductHelper.getSegments((Collection)product.getSegmentTariffs())) {
            CouponInfoType couponInfo = ticketItem.getCouponInfoList().stream().filter(ci -> seg.getGdsId().equals(FlyArystanAncHelper.getGdsSegmentId(ci))).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find segment for ref={0}", (Object[])new Object[]{seg.getGdsId()}));
            FareInfoType fareInfo = couponInfo.getCouponFlightSegment().getFareInfo();
            seg.setFareBasis(fareInfo.getFareReferenceCode());
            FlyArystanHelper.setFareReferenceID(seg, fareInfo.getFareReferenceID());
        }
    }

    private static ProductFare createProductFare(AmountType gdsAmount) {
        ProductFare fare = new ProductFare();
        fare.setEquivalentFare(FlyArystanAncHelper.toBigDecimal(gdsAmount));
        fare.setBaseFare(MoneyHelper.buildMoney((BigDecimal)fare.getEquivalentFare(), (String)gdsAmount.getCurrency().getCode()));
        return fare;
    }

    private static List<Tax> buildTaxes(TaxesType taxes) {
        if (taxes == null || CollectionUtil.isEmpty((Collection)taxes.getTaxList())) {
            return Collections.emptyList();
        }
        ArrayList<Tax> result = new ArrayList<Tax>();
        for (AirTaxType gdsTax : taxes.getTaxList()) {
            Tax tax = new Tax();
            tax.setCode(gdsTax.getTaxCode());
            tax.setEquivalentAmount(FlyArystanAncHelper.toBigDecimal(gdsTax.getTaxAmount()));
            tax.setAmount(MoneyHelper.buildMoney((BigDecimal)tax.getEquivalentAmount(), (String)gdsTax.getTaxAmount().getCurrency().getCode()));
            result.add(tax);
        }
        return result;
    }
}

