/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.getAncillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescription;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanAncHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.ancillary.AirAvailSpecialServicesResponseType;
import com.hititcs.crane.ws.ancillary.AvailSpecialServiceType;
import com.hititcs.crane.ws.ancillary.SsrType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FlyArystanGetServicesResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        AirAvailSpecialServicesResponseType response = (AirAvailSpecialServicesResponseType)ctx.getMandatoryObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_RESPONSE);
        ctx.putObject((Enum)IBusMidofficeContextKeys.ANCILLARY_FEES, this.buildAncillaryFees(response, reservation));
    }

    private List<AncillaryFee> buildAncillaryFees(AirAvailSpecialServicesResponseType response, Reservation reservation) {
        Set passengerTypes = AirProductHelper.getAirProductsStream((Reservation)reservation).map(Product::getPassengerType).filter(Objects::nonNull).filter(pt -> !DictHelper.isInfantPassengerTypeCategory((DictionaryReference)pt)).collect(Collectors.toSet());
        Product firstProduct = (Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0);
        ArrayList<AncillaryFee> result = new ArrayList<AncillaryFee>();
        if (CollectionUtil.isEmpty((Collection)response.getAvailSpecialServices().getAvailSpecialServiceList())) {
            return result;
        }
        for (AvailSpecialServiceType availSpecialService : response.getAvailSpecialServices().getAvailSpecialServiceList()) {
            Integer segNumber = FlyArystanAncHelper.calcSegmentNumber(firstProduct, availSpecialService.getFlightSegment().getFlightSegmentID());
            for (SsrType ssr : availSpecialService.getAvailableSSRList()) {
                BigDecimal price = FlyArystanAncHelper.toBigDecimal(ssr.getPrice());
                if (MiscUtil.isZero((BigDecimal)price, (boolean)true)) continue;
                String ssrGroupCode = ssr.getGroupCode();
                String ssrCode = ssr.getCode();
                MiscUtil.Pair<AncillaryFeeType, AncillaryFeeDescription> afPair = FlyArystanHelper.getAncillaryFeeTypeDescription(ssrGroupCode, ssrCode);
                AncillaryFeeType ancillaryFeeType = (AncillaryFeeType)afPair.getFirst();
                AncillaryFeeDescription ancillaryFeeDescription = (AncillaryFeeDescription)afPair.getSecond();
                for (DictionaryReference passengerType : passengerTypes) {
                    AncillaryFee fee = new AncillaryFee();
                    fee.setType(ancillaryFeeType);
                    fee.setPassengerType(passengerType);
                    fee.setGdsDescription(ssr.getExplanation());
                    fee.setBaseAmount(MoneyHelper.buildMoney((BigDecimal)price, (String)ssr.getPrice().getCurrency().getCode()));
                    fee.setEquivalentAmount(price);
                    fee.setDescription(DictHelper.toReference((BaseDictionary)ancillaryFeeDescription));
                    fee.getSegmentNumbers().add(segNumber);
                    fee.setGdsId(FlyArystanAncHelper.buildAncillaryFeeGdsId(segNumber, ssrGroupCode, ssrCode));
                    fee.setMaxQuantityPerPassenger(Integer.valueOf(ssr.getAllowedQuantityPerPassenger()));
                    fee.setFreeTextAvailability(FlyArystanAncHelper.convertFreeTextAvailabilityFromGds(ssr.getFreeTextInRequest()));
                    result.add(fee);
                }
            }
        }
        return result;
    }
}

