/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.refundReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.GdsProductRefexFinanceDetails;
import com.gridnine.xtrip.common.midoffice.model.UnsellFinanceDetails;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.main.AirBookingType;
import com.hititcs.crane.ws.main.AirCancelBookingResponse;
import com.hititcs.crane.ws.main.AirReservationType;
import com.hititcs.crane.ws.main.PricingInfoType;
import com.hititcs.crane.ws.main.TicketInfoType;
import com.hititcs.crane.ws.main.TicketItemType;
import java.math.BigDecimal;
import java.util.List;

public class RefundResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) {
        AirCancelBookingResponse response = (AirCancelBookingResponse)ctx.getMandatoryObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_RESPONSE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        UnsellFinanceDetails unsellFinanceDetails = (UnsellFinanceDetails)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_FINANCE_DETAILS);
        List products = GDSHelper.getAllEffectiveProducts((Reservation)reservation);
        AirBookingType airBooking = (AirBookingType)response.getAirBookingList().get(0);
        AirReservationType airReservation = airBooking.getAirReservation();
        TicketInfoType ticketInfo = airBooking.getTicketInfo();
        for (Product product : products) {
            GdsProductRefexFinanceDetails gdsDetails = new GdsProductRefexFinanceDetails();
            TicketItemType ticketItem = ticketInfo.getTicketItemList().stream().filter(ti -> product.getGdsId().equals(FlyArystanHelper.buildGdsId(ti, airReservation))).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find ticketItem by gdsId {0}", (Object[])new Object[]{product.getGdsId()}));
            gdsDetails.setPossible(true);
            PricingInfoType refundPricingInfo = ticketItem.getRefundPricingInfo();
            BigDecimal equivalentFare = FlyArystanHelper.calcGdsFareAmount(refundPricingInfo);
            gdsDetails.setBaseFare(MoneyHelper.buildMoney((BigDecimal)equivalentFare, (String)product.getGdsCurrency()));
            gdsDetails.setEquivalentFare(equivalentFare);
            FlyArystanHelper.buildTaxes(refundPricingInfo).stream().map(AirProductTaxHelper::toSimpleTax).forEach(gdsDetails.getTaxes()::add);
            gdsDetails.setPenalty(FlyArystanHelper.toBigDecimal(ticketItem.getPricingOverview().getTotalPenalty()));
            unsellFinanceDetails.getGdsDetails().put((Object)product.getUid(), (Object)gdsDetails);
        }
    }
}

