/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.repriceReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.server.gds.GDSRepriceHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.main.AirBookingResponseType;
import com.hititcs.crane.ws.main.AirBookingType;
import com.hititcs.crane.ws.main.AirReservationType;
import com.hititcs.crane.ws.main.AirTicketReservationResponse;
import com.hititcs.crane.ws.main.TicketInfoType;
import com.hititcs.crane.ws.main.TicketItemType;
import java.util.ArrayList;
import java.util.List;

public class FlyArystanPreTicketResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        AirTicketReservationResponse response = (AirTicketReservationResponse)ctx.getMandatoryObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_RESPONSE);
        ArrayList<Message> messages = new ArrayList<Message>();
        this.updateReservation(reservation, (AirBookingResponseType)response, messages);
        ctx.addMessages(messages);
    }

    private void updateReservation(Reservation reservation, AirBookingResponseType response, List<Message> messages) throws Exception {
        AirBookingType airBooking = (AirBookingType)response.getAirBookingList().get(0);
        AirReservationType airReservation = airBooking.getAirReservation();
        TicketInfoType ticketInfo = airBooking.getTicketInfo();
        for (Product prod : AirProductHelper.getProducts((Reservation)reservation)) {
            if (ProductStatusHandler.getAllNonIssuedVoidStatuses().contains(prod.getStatus())) continue;
            TicketItemType ticketItem = ticketInfo.getTicketItemList().stream().filter(ti -> prod.getGdsId().equals(FlyArystanHelper.buildGdsId(ti, airReservation))).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find ticketItem by gdsId {0}", (Object[])new Object[]{prod.getGdsId()}));
            GDSRepriceHelper.updateAndCheckProductPrices((Product)prod, product -> {
                FlyArystanHelper.updateProduct(product, ticketItem);
                product.setTotalVendorEquivalentVatAmount(null);
            }, messages);
        }
    }
}

