/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.searchFlightFares;

import com.gridnine.xtrip.common.gds.flyArystan.dict.FarePackage;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.main.AvailOriginDestinationOptionType;
import com.hititcs.crane.ws.main.AvailabilityByDateType;
import com.hititcs.crane.ws.main.AvailabilityResultType;
import com.hititcs.crane.ws.main.AvailabilityRouteType;
import com.hititcs.crane.ws.main.AvailabilityType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class FlyArystanSearchFlightFaresResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        AvailabilityType response = (AvailabilityType)ctx.getMandatoryObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_RESPONSE);
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHTS, this.buildFlights(response, flight));
    }

    private Collection<Flight> buildFlights(AvailabilityType response, Flight sourceFlight) {
        List<AvailOriginDestinationOptionType> originDestinations = sourceFlight.getSegmentTariffs().stream().map(st -> this.findAvailOriginDestinationOption(response, (FlightSegmentTariff)st, sourceFlight.getSegmentTariffs().indexOf(st))).collect(Collectors.toList());
        ArrayList<Flight> result = new ArrayList<Flight>();
        if (originDestinations.isEmpty()) {
            return result;
        }
        Collection<String> fareGroupNames = FlyArystanHelper.collectFareGroupNames(originDestinations);
        for (String fareGroupName : fareGroupNames) {
            Flight buildFlight = FlyArystanHelper.buildFlight(originDestinations, fareGroupName, null);
            if (buildFlight != null) {
                result.add(buildFlight);
            }
            List<FarePackage> farePackages = FlyArystanHelper.collectFarePackages(originDestinations, fareGroupName);
            for (FarePackage farePackage : farePackages) {
                Flight flight = FlyArystanHelper.buildFlight(originDestinations, fareGroupName, farePackage);
                if (flight == null) continue;
                result.add(flight);
            }
        }
        return result;
    }

    private AvailOriginDestinationOptionType findAvailOriginDestinationOption(AvailabilityType response, FlightSegmentTariff st, int segTariffInd) {
        AvailabilityByDateType availabilityByDate = (AvailabilityByDateType)((AvailabilityRouteType)((AvailabilityResultType)response.getAvailabilityResultList().get(0)).getAvailabilityRouteList().get(segTariffInd)).getAvailabilityByDateList().get(0);
        return availabilityByDate.getOriginDestinationOptionList().stream().filter(od -> this.isSelected((AvailOriginDestinationOptionType)od, st)).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find fareComponentGroup for {0} segmentTariff", (Object[])new Object[]{segTariffInd}));
    }

    private boolean isSelected(AvailOriginDestinationOptionType od, FlightSegmentTariff st) {
        FlightSegmentTariff gdsFst = FlyArystanHelper.buildFlightSegmentTariff(od);
        if (st.getSegments().size() != gdsFst.getSegments().size()) {
            return false;
        }
        int segInd = 0;
        for (FlightSegment seg : st.getSegments()) {
            FlightSegment gdsSeg = (FlightSegment)gdsFst.getSegments().get(segInd++);
            if (!MiscUtil.equals((Object)seg.getFlightNumber(), (Object)gdsSeg.getFlightNumber())) {
                return false;
            }
            if (!MiscUtil.equals((Object)seg.getDateBegin(), (Object)gdsSeg.getDateBegin())) {
                return false;
            }
            if (MiscUtil.equals((Object)seg.getAirline(), (Object)gdsSeg.getAirline())) continue;
            return false;
        }
        return true;
    }
}

