/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.searchFlightFares;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanTestBase;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.gds.flyArystan.searchFlightFares.FlyArystanSearchFlightFaresResponseParser;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.test.TestFlightBuilder;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.main.GetAvailabilityResponse;
import java.util.List;
import org.junit.Test;

public class FlyArystanSearchFlightFaresResponseParserTest
extends FlyArystanTestBase {
    private final FlyArystanSearchFlightFaresResponseParser processor = new FlyArystanSearchFlightFaresResponseParser();

    public void setUp() throws Exception {
        super.setUp();
        this.initDicts();
    }

    @Test
    public void testOW() throws Throwable {
        String scenario = "ALA-NQZ";
        Flight flight = new TestFlightBuilder().segmentTariff().segment().airline("0Q").locationBegin("ALA").locationEnd("NQZ").dateBegin("2020-10-10 07:45:00").flightNumber("7051").end().end().getEntity();
        this.testScenario(scenario, flight);
    }

    @Test
    public void testRT() throws Throwable {
        String scenario = "ALA-NQZ-ALA";
        Flight flight = new TestFlightBuilder().segmentTariff().segment().airline("0Q").locationBegin("ALA").locationEnd("NQZ").dateBegin("2020-09-22 07:45:00").flightNumber("7051").end().end().segmentTariff().segment().airline("0Q").locationBegin("NQZ").locationEnd("ALA").dateBegin("2020-09-29 00:55:00").flightNumber("7058").end().end().getEntity();
        this.testScenario(scenario, flight);
    }

    @Test
    public void testNotDirectFlightWithOtherPackages() throws Throwable {
        String scenario = "NQZ-ALA";
        Flight flight = new TestFlightBuilder().segmentTariff().segment().airline("0Q").locationBegin("NQZ").locationEnd("PLX").dateBegin("2021-08-24 12:25:00").flightNumber("7351").end().segment().airline("0Q").locationBegin("PLX").locationEnd("ALA").dateBegin("2021-08-24 16:30:00").flightNumber("7154").end().end().getEntity();
        this.testScenario(scenario, flight);
    }

    @Test
    public void testXtr10855() throws Throwable {
        String scenario = "xtr10855";
        Flight flight = new TestFlightBuilder().segmentTariff().segment().airline("0Q").locationBegin("NQZ").locationEnd("ALA").dateBegin("2021-08-28 10:15:00").flightNumber("7052").end().end().getEntity();
        this.testScenario(scenario, flight);
    }

    @Test
    public void testCollectionWithoutEmptyFlights() throws Throwable {
        String scenario = "ALA-CIT";
        Flight flight = new TestFlightBuilder().segmentTariff().segment().airline("0Q").locationBegin("ALA").locationEnd("CIT").dateBegin("2022-10-15 14:30:00").flightNumber("7105").end().end().getEntity();
        this.testScenario(scenario, flight);
    }

    private void testScenario(String scenario, Flight flight) throws Exception {
        String responseFile = scenario + ".xml";
        String resultFile = scenario + "_result.xml";
        GetAvailabilityResponse response = this.readResponseFromFile(GetAvailabilityResponse.class, responseFile);
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_RESPONSE, (Object)response.getAvailability());
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)flight);
        this.processor.process(ctx);
        List actualList = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        List expectedList = this.loadXSerializableList(resultFile);
        this.assertFlights(expectedList, actualList);
    }
}

