/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.searchFlights;

import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanWsRequestParams;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jaxws.JaxWsHelper;
import com.hititcs.crane.ws.main.AirAvailabilityRequestType;
import com.hititcs.crane.ws.main.AirTripType;
import com.hititcs.crane.ws.main.BasicRequestType;
import com.hititcs.crane.ws.main.OriginDestinationInformationType;
import com.hititcs.crane.ws.main.PassengerTypeQuantityType;
import com.hititcs.crane.ws.main.PassengerTypeType;
import com.hititcs.crane.ws.main.TravelerInformationType;
import java.util.Date;
import java.util.List;

public class FlyArystanSearchFlightsRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        ctx.putObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_REQUEST_PARAMS, (Object)new FlyArystanWsRequestParams("getAvailability", (BasicRequestType)this.buildRequest(fsp)));
    }

    private AirAvailabilityRequestType buildRequest(FlightSearchParameters fsp) {
        boolean hasKC;
        AirAvailabilityRequestType req = new AirAvailabilityRequestType();
        if (!fsp.getPreferredAirlines().isEmpty() && !(hasKC = fsp.getPreferredAirlines().stream().anyMatch(FlyArystanHelper::isFlyArystanAirline))) {
            throw Xeption.forAdmin((String)"mandatory airlines hasn't KC", (Object[])new Object[0]);
        }
        String cabinClass = FlyArystanHelper.convertServiceClassToGds(fsp.getServiceClass());
        boolean useCitySearch = fsp.getRoute().stream().anyMatch(rs -> FlyArystanSearchFlightsRequestBuilder.isCity((DictionaryReference<GeoLocation>)rs.getLocationBegin()) || FlyArystanSearchFlightsRequestBuilder.isCity((DictionaryReference<GeoLocation>)rs.getLocationEnd()));
        req.setUseCitySearch(useCitySearch);
        for (RouteSegment rs2 : fsp.getRoute()) {
            OriginDestinationInformationType od = new OriginDestinationInformationType();
            od.setOriginLocation(FlyArystanHelper.buildGdsLocation((DictionaryReference<GeoLocation>)rs2.getLocationBegin(), useCitySearch));
            od.setDestinationLocation(FlyArystanHelper.buildGdsLocation((DictionaryReference<GeoLocation>)rs2.getLocationEnd(), useCitySearch));
            od.setDepartureDateTime(JaxWsHelper.toGregorianLocalDateTime((Date)MiscUtil.clearTime((Date)rs2.getDate())));
            od.setPrefferedCabinClass(cabinClass);
            req.getOriginDestinationInformationList().add(od);
        }
        req.setTripType(this.buildTripType(fsp.getRoute()));
        req.setTravelerInformation(this.buildTravelerInformation(fsp.getSeats()));
        if (fsp.isSkipConnected()) {
            req.setMaxConnections(Integer.valueOf(0));
        }
        return req;
    }

    private static boolean isCity(DictionaryReference<GeoLocation> locationRef) {
        return ((GeoLocation)DictionaryCache.get().resolveReference(locationRef)).getType() == LocationType.CITY;
    }

    private TravelerInformationType buildTravelerInformation(List<SeatPreferences> seats) {
        TravelerInformationType travelerInformation = new TravelerInformationType();
        for (SeatPreferences sp : GDSHelper.sortByPassengerType(seats)) {
            PassengerTypeQuantityType pq = new PassengerTypeQuantityType();
            PassengerTypeType gdsPassengerType = FlyArystanHelper.buildGdsPassengerType((DictionaryReference<PassengerType>)sp.getPassengerType());
            pq.setPassengerType(gdsPassengerType);
            pq.setQuantity(sp.getCount());
            travelerInformation.getPassengerTypeQuantityList().add(pq);
        }
        return travelerInformation;
    }

    private AirTripType buildTripType(List<RouteSegment> legs) {
        if (legs.size() == 1) {
            return AirTripType.ONE_WAY;
        }
        if (legs.size() == 2) {
            RouteSegment seg1 = legs.get(0);
            RouteSegment seg2 = legs.get(1);
            if (MiscUtil.equals((Object)seg1.getLocationBegin(), (Object)seg2.getLocationEnd()) && MiscUtil.equals((Object)seg1.getLocationEnd(), (Object)seg2.getLocationBegin())) {
                return AirTripType.ROUND_TRIP;
            }
        }
        return AirTripType.MULTI_DIRECTIONAL;
    }
}

