/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.searchFlights;

import com.gridnine.xtrip.common.gds.flyArystan.dict.FarePackage;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.main.AvailOriginDestinationOptionType;
import com.hititcs.crane.ws.main.AvailabilityByDateType;
import com.hititcs.crane.ws.main.AvailabilityFareComponentType;
import com.hititcs.crane.ws.main.AvailabilityResultType;
import com.hititcs.crane.ws.main.AvailabilityRouteType;
import com.hititcs.crane.ws.main.AvailabilityType;
import com.hititcs.crane.ws.main.LocationType;
import com.hititcs.crane.ws.main.PricingOverviewType;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;

public class FlyArystanSearchFlightsResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AvailabilityType response = (AvailabilityType)ctx.getMandatoryObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_RESPONSE);
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHTS, FlyArystanSearchFlightsResponseParser.buildFlights(response, fsp));
    }

    private static Collection<Flight> buildFlights(AvailabilityType response, FlightSearchParameters fsp) {
        ArrayList<Flight> result = new ArrayList<Flight>();
        for (AvailabilityResultType availabilityResult : response.getAvailabilityResultList()) {
            ArrayList allVariants = new ArrayList();
            for (RouteSegment rs : fsp.getRoute()) {
                allVariants.add(availabilityResult.getAvailabilityRouteList().stream().filter(route -> FlyArystanSearchFlightsResponseParser.matches(route, rs)).map(FlyArystanSearchFlightsResponseParser::getOriginDestinations).flatMap(Collection::stream).collect(Collectors.toList()));
            }
            List cartesianVariants = CollectionUtil.cartesianProduct(allVariants);
            if (fsp.isExcludeBaglessFares()) {
                for (List originDestinations : cartesianVariants) {
                    Collection<String> fareGroupNames;
                    List<InfoForBuildFlight> data;
                    if (!CollectionUtil.isNotEmpty((Collection)originDestinations) || (data = FlyArystanSearchFlightsResponseParser.createInfoData(originDestinations, fareGroupNames = FlyArystanHelper.collectFareGroupNames(originDestinations))).isEmpty()) continue;
                    InfoForBuildFlight cheapestInfo = FlyArystanSearchFlightsResponseParser.getCheapestInfo(data);
                    try {
                        Flight cheapestFlight = FlyArystanHelper.buildFlight(originDestinations, cheapestInfo.getFareGroupName(), cheapestInfo.getFarePackage());
                        result.add(cheapestFlight);
                    }
                    catch (Exception ex) {
                        IncidentsLog.reportException((String)"failed to build flight", (Throwable)ex);
                    }
                }
                continue;
            }
            cartesianVariants.stream().map(ods -> {
                try {
                    return FlyArystanHelper.buildFlight(ods, null, null);
                }
                catch (Exception ex) {
                    IncidentsLog.reportException((String)"failed to build flight", (Throwable)ex);
                    return null;
                }
            }).filter(Objects::nonNull).forEach(result::add);
        }
        return result;
    }

    private static boolean matches(AvailabilityRouteType route, RouteSegment rs) {
        return FlyArystanSearchFlightsResponseParser.matches(((LocationType)route.getRouteInfo().getLocationCodeList().get(0)).getLocationCode(), (DictionaryReference<GeoLocation>)rs.getLocationBegin()) && FlyArystanSearchFlightsResponseParser.matches(((LocationType)route.getRouteInfo().getLocationCodeList().get(1)).getLocationCode(), (DictionaryReference<GeoLocation>)rs.getLocationEnd()) && ((XMLGregorianCalendar)((AvailabilityByDateType)route.getAvailabilityByDateList().get(0)).getDateList().get(0)).toGregorianCalendar().toZonedDateTime().toLocalDate().equals(rs.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
    }

    private static boolean matches(String responseCode, DictionaryReference<GeoLocation> requestLocationRef) {
        DictionaryReference<GeoLocation> responseLocationRef = FlyArystanHelper.resolveNativeCode(GeoLocation.class, responseCode);
        if (requestLocationRef.equals(responseLocationRef)) {
            return true;
        }
        GeoLocation responseLocation = (GeoLocation)DictionaryCache.get().resolveReference(responseLocationRef);
        return responseLocation.getParent().equals(requestLocationRef);
    }

    private static List<AvailOriginDestinationOptionType> getOriginDestinations(AvailabilityRouteType availabilityRoute) {
        AvailabilityByDateType availabilityByDate = (AvailabilityByDateType)availabilityRoute.getAvailabilityByDateList().get(0);
        List list = availabilityByDate.getOriginDestinationOptionList();
        return list == null ? new ArrayList<AvailOriginDestinationOptionType>() : new ArrayList(list);
    }

    private static List<InfoForBuildFlight> createInfoData(List<AvailOriginDestinationOptionType> originDestinations, Collection<String> fareGroupNames) {
        ArrayList<InfoForBuildFlight> data = new ArrayList<InfoForBuildFlight>();
        fareGroupNames.forEach(fareGroupName -> FlyArystanHelper.collectFarePackages(originDestinations, fareGroupName).stream().filter(farePackage -> FlyArystanSearchFlightsResponseParser.hasBaggage(originDestinations, fareGroupName, farePackage)).map(farePackage -> new InfoForBuildFlight(FlyArystanSearchFlightsResponseParser.calculateTotalAmount(originDestinations, fareGroupName), (String)fareGroupName, (FarePackage)farePackage)).forEach(data::add));
        return data;
    }

    private static boolean hasBaggage(List<AvailOriginDestinationOptionType> originDestinations, String fareGroupName, FarePackage farePackage) {
        return originDestinations.stream().map(originDestination -> FlyArystanHelper.collectFareComponents(originDestination, fareGroupName)).filter(CollectionUtil::isNotEmpty).flatMap(Collection::stream).flatMap(fareComponent -> fareComponent.getPassengerFareInfoList().stream()).flatMap(pfi -> pfi.getFareInfoList().stream()).map(gdsFareInfo -> FlyArystanHelper.findFarePkgInfo(gdsFareInfo, farePackage)).filter(Objects::nonNull).map(FlyArystanHelper::getPackageLuggageInfo).filter(Objects::nonNull).anyMatch(packageLuggageInfo -> !packageLuggageInfo.isNil());
    }

    private static BigDecimal calculateTotalAmount(List<AvailOriginDestinationOptionType> originDestinations, String fareGroupName) {
        return originDestinations.stream().map(originDestination -> FlyArystanHelper.collectFareComponents(originDestination, fareGroupName)).filter(CollectionUtil::isNotEmpty).flatMap(Collection::stream).map(AvailabilityFareComponentType::getPricingOverview).map(PricingOverviewType::getTotalAmount).map(FlyArystanHelper::toBigDecimal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static InfoForBuildFlight getCheapestInfo(List<InfoForBuildFlight> data) {
        if (data.size() == 1) {
            return data.get(0);
        }
        InfoForBuildFlight cheapestInfo = null;
        for (InfoForBuildFlight info : data) {
            if (cheapestInfo == null) {
                cheapestInfo = info;
            }
            if (cheapestInfo.getTotalAmount().compareTo(info.getTotalAmount()) < 0) continue;
            cheapestInfo = info;
        }
        return cheapestInfo;
    }

    private static class InfoForBuildFlight {
        private final BigDecimal totalAmount;
        private final String fareGroupName;
        private final FarePackage farePackage;

        public InfoForBuildFlight(BigDecimal totalAmount, String fareGroupName, FarePackage farePackage) {
            this.totalAmount = totalAmount;
            this.fareGroupName = fareGroupName;
            this.farePackage = farePackage;
        }

        public BigDecimal getTotalAmount() {
            return this.totalAmount;
        }

        public String getFareGroupName() {
            return this.fareGroupName;
        }

        public FarePackage getFarePackage() {
            return this.farePackage;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InfoForBuildFlight info = (InfoForBuildFlight)o;
            return Objects.equals(this.totalAmount, info.totalAmount) && Objects.equals(this.fareGroupName, info.fareGroupName) && Objects.equals(this.farePackage, info.farePackage);
        }

        public int hashCode() {
            return Objects.hash(this.totalAmount, this.fareGroupName, this.farePackage);
        }
    }
}

