/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.searchFlights;

import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanTestBase;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.gds.flyArystan.searchFlights.FlyArystanSearchFlightsResponseParser;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.main.GetAvailabilityResponse;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.junit.Test;

public class FlyArystanSearchFlightsResponseParserTest
extends FlyArystanTestBase {
    private final FlyArystanSearchFlightsResponseParser processor = new FlyArystanSearchFlightsResponseParser();

    public void setUp() throws Exception {
        super.setUp();
        this.initDicts();
    }

    private static RouteSegment routeSegment(String from, String to, int year, int month, int day) {
        RouteSegment rs = new RouteSegment();
        rs.setLocationBegin(FlyArystanHelper.resolveNativeCode(GeoLocation.class, from));
        rs.setLocationEnd(FlyArystanHelper.resolveNativeCode(GeoLocation.class, to));
        rs.setDate(Date.from(LocalDate.of(year, month, day).atStartOfDay(ZoneId.systemDefault()).toInstant()));
        return rs;
    }

    @Test
    public void testOW() throws Throwable {
        String scenario = "ALA-NQZ_ECONOMY";
        this.testScenario(scenario, Collections.singletonList(FlyArystanSearchFlightsResponseParserTest.routeSegment("ALA", "NQZ", 2020, 10, 10)));
    }

    @Test
    public void testOWBusiness() throws Throwable {
        String scenario = "ALA-NQZ_BUSINESS";
        this.testScenario(scenario, Collections.singletonList(FlyArystanSearchFlightsResponseParserTest.routeSegment("ALA", "NQZ", 2020, 9, 3)));
    }

    @Test
    public void testNotDirectFlightWithOtherPackages() throws Throwable {
        String scenario = "NQZ-ALA";
        this.testScenario(scenario, Collections.singletonList(FlyArystanSearchFlightsResponseParserTest.routeSegment("NQZ", "ALA", 2021, 8, 24)));
    }

    @Test
    public void testRT() throws Throwable {
        String scenario = "ALA-NQZ-ALA";
        this.testScenario(scenario, Arrays.asList(FlyArystanSearchFlightsResponseParserTest.routeSegment("ALA", "NQZ", 2020, 9, 22), FlyArystanSearchFlightsResponseParserTest.routeSegment("NQZ", "ALA", 2020, 9, 29)));
    }

    @Test
    public void testIbe3432() throws Throwable {
        String scenario = "IBE-3432";
        this.testScenario(scenario, Arrays.asList(FlyArystanSearchFlightsResponseParserTest.routeSegment("ALA", "NQZ", 2021, 6, 16), FlyArystanSearchFlightsResponseParserTest.routeSegment("NQZ", "ALA", 2021, 6, 23)));
    }

    private void testScenario(String scenario, List<RouteSegment> route) throws Exception {
        String responseFile = scenario + ".xml";
        String resultFile = scenario + "_result.xml";
        GetAvailabilityResponse response = this.readResponseFromFile(GetAvailabilityResponse.class, responseFile);
        FlightSearchParameters fsp = new FlightSearchParameters();
        fsp.getRoute().addAll(route);
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_RESPONSE, (Object)response.getAvailability());
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)fsp);
        this.processor.process(ctx);
        List actualList = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        List expectedList = this.loadXSerializableList(resultFile);
        this.assertFlights(expectedList, actualList);
    }
}

