/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.gds.flyArystan.FlyArystanGdsAccount;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.GDSRepriceHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanWsRequestParams;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.main.AirTicketReservationRequestType;
import com.hititcs.crane.ws.main.AmountType;
import com.hititcs.crane.ws.main.BasicRequestType;
import com.hititcs.crane.ws.main.CurrencyType;
import com.hititcs.crane.ws.main.FullfillmentType;
import com.hititcs.crane.ws.main.MiscChargeOrderType;
import com.hititcs.crane.ws.main.PaymentDetailType;
import com.hititcs.crane.ws.main.PaymentDetailsType;
import com.hititcs.crane.ws.main.PaymentTypeCodesType;
import java.math.BigDecimal;

public class FlyArystanTicketRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        ctx.putObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_REQUEST_PARAMS, (Object)new FlyArystanWsRequestParams("ticketReservation", (BasicRequestType)this.buildRequest(reservation, (FlyArystanGdsAccount)accountCtr.getEntity())));
    }

    private AirTicketReservationRequestType buildRequest(Reservation reservation, FlyArystanGdsAccount account) {
        AirTicketReservationRequestType result = new AirTicketReservationRequestType();
        result.setBookingReferenceID(FlyArystanHelper.buildBookingReferenceId(reservation));
        FullfillmentType ff = new FullfillmentType();
        PaymentDetailsType pds = new PaymentDetailsType();
        PaymentDetailType pd = new PaymentDetailType();
        pd.setPrimaryPayment(true);
        pd.setPaymentAmount(this.buildPaymentAmount(this.getTotalTicketsAmount(reservation), this.getGdsCurrency(reservation)));
        pd.setPaymentType(PaymentTypeCodesType.MISC_CHARGE_ORDER);
        MiscChargeOrderType mco = new MiscChargeOrderType();
        mco.setPaymentCode("INV");
        mco.setMCONumber(account.getInvoiceNumber());
        pd.setMiscChargeOrder(mco);
        pds.getPaymentDetailList().add(pd);
        ff.setPaymentDetails(pds);
        result.setFullfillment(ff);
        result.setRequestPurpose("COMMIT");
        return result;
    }

    private BigDecimal getTotalTicketsAmount(Reservation res) {
        BigDecimal amount = BigDecimal.ZERO;
        for (Product prod : GDSHelper.getAllProducts((Reservation)res)) {
            if (prod.getStatus() != ProductStatus.BOOKING) continue;
            amount = amount.add(GDSRepriceHelper.getTotal((Product)prod));
        }
        return amount;
    }

    private String getGdsCurrency(Reservation reservation) {
        Product firstProduct = (Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0);
        return firstProduct.getGdsCurrency();
    }

    private AmountType buildPaymentAmount(BigDecimal value, String currency) {
        AmountType result = new AmountType();
        result.setValue(value.doubleValue());
        CurrencyType ct = new CurrencyType();
        ct.setCode(currency);
        result.setCurrency(ct);
        return result;
    }
}

