/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.main.AirBookingResponseType;
import com.hititcs.crane.ws.main.AirBookingType;
import com.hititcs.crane.ws.main.AirReservationType;
import com.hititcs.crane.ws.main.TicketInfoType;
import com.hititcs.crane.ws.main.TicketItemType;
import java.util.Date;

public class FlyArystanTicketResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        AirBookingResponseType response = (AirBookingResponseType)ctx.getMandatoryObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_AIR_BOOKING_RESPONSE);
        this.updateReservation(reservation, response);
    }

    private void updateReservation(Reservation reservation, AirBookingResponseType response) {
        AirBookingType airBooking = (AirBookingType)response.getAirBookingList().get(0);
        AirReservationType airReservation = airBooking.getAirReservation();
        TicketInfoType ticketInfo = airBooking.getTicketInfo();
        for (Product prod : AirProductHelper.getProducts((Reservation)reservation)) {
            if (ProductStatusHandler.getAllNonIssuedVoidStatuses().contains(prod.getStatus())) continue;
            TicketItemType ticketItem = ticketInfo.getTicketItemList().stream().filter(ti -> prod.getGdsId().equals(FlyArystanHelper.buildGdsId(ti, airReservation))).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find ticketItem by gdsId {0}", (Object[])new Object[]{prod.getGdsId()}));
            prod.setIssueDate(new Date());
            prod.setStatus(ProductStatus.SELL);
            FlyArystanHelper.updateTicketNumber(prod, ticketItem.getTicketDocumentNbr());
            prod.setProviderSystemNumber(ticketItem.getOriginalTicketNumber());
            prod.setConjCount(ticketItem.getConjunctiveTicketList().size() - 1);
        }
    }
}

