/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flyArystan.updateMcoReservationRequestStatus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.gds.flyArystan.IBusGdsFlyArystanContextKeys;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.hititcs.crane.ws.main.AirBookingResponseType;
import com.hititcs.crane.ws.main.AirBookingType;
import com.hititcs.crane.ws.main.AirReservationType;
import com.hititcs.crane.ws.main.CouponInfoType;
import com.hititcs.crane.ws.main.TicketInfoType;
import com.hititcs.crane.ws.main.TicketItemType;
import com.hititcs.crane.ws.main.TicketReservationResponse;
import java.util.Date;

public class FlyArystanUpdateMcoReservationRequestStatusProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        TicketReservationResponse response = (TicketReservationResponse)ctx.getMandatoryObject((Enum)IBusGdsFlyArystanContextKeys.FLY_ARYSTAN_RESPONSE);
        this.updateMcoStatuses(reservation, (AirBookingResponseType)response.getAirTicketReservationResponse());
    }

    private void updateMcoStatuses(Reservation reservation, AirBookingResponseType airResponse) {
        AirBookingType airBooking = (AirBookingType)airResponse.getAirBookingList().get(0);
        AirReservationType airReservation = airBooking.getAirReservation();
        TicketInfoType ticketInfo = airBooking.getTicketInfo();
        for (Product product : GDSHelper.getMcoProducts((Reservation)reservation)) {
            if (ProductStatusHandler.getAllNonIssuedVoidStatuses().contains(product.getStatus())) continue;
            TicketItemType ticketItem = ticketInfo.getTicketItemList().stream().filter(ti -> product.getGdsId().equals(FlyArystanHelper.buildGdsId(ti, airReservation))).findFirst().orElse(null);
            if (ticketItem == null) {
                product.setStatus(ProductStatus.VOID_BOOKING);
                product.setIssueDate(new Date());
                continue;
            }
            String actionCode = ((CouponInfoType)ticketItem.getCouponInfoList().get(0)).getCouponFlightSegment().getActionCode();
            product.setMcoReservationRequestStatus(FlyArystanHelper.getMcoReservationRequestStatus(actionCode));
        }
    }
}

