/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai;

import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.SimpleCompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.gds.flydubai.TravelAgentData;
import com.gridnine.xtrip.server.gds.flydubai.ibus.FlyDubaiResponseException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.datacontract.schemas.radixx.connectpoint.ExceptionInformationException;
import org.datacontract.schemas.radixx.connectpoint.ExceptionInformationExceptions;
import org.datacontract.schemas.radixx.connectpoint.ExceptionLevels;
import org.datacontract.schemas.radixx.connectpoint.pricing.FareInfo;

public class FlyDubaiHelper {
    public static final String CARRIER_CODE = "FZ";
    public static final String PROP_FAREID = "fareId";
    public static final String PROP_SEARCH_PARAMS = "searchParams";
    public static final String FLYDUBAI_FARE_CODE = "flydubai-fare-code";
    private static final int MAX_CHILD_AGE = 12;
    private static final int MIN_CHILD_AGE = 2;
    public static final String LOCATION_RUS_CODE = "RU";
    public static final String CHARGE_TYPE_TFEE = "TFEE";
    public static final Set<String> baggageTaxCodes = new HashSet<String>();
    private static final CodeTranslator CODE_TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.IATA.name()});
    private static final CodeTranslator FLY_DUBAI_CODE_TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.FLY_DUBAI.name()});
    private static int ADDRESS_LENGTH;

    public static boolean isBaggageTaxCode(String taxCode) {
        if (taxCode == null) {
            return false;
        }
        return baggageTaxCodes.contains(taxCode.trim());
    }

    public static <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code) {
        return CODE_TRANSLATOR.resolveNativeCode(cls, code);
    }

    public static <D extends BaseDictionary> String getNativeCode(DictionaryReference<D> ref) {
        return CODE_TRANSLATOR.getNativeCode(ref, false);
    }

    public static String getFakeReservationNumber() throws Exception {
        SimpleCompositeNumber number = new SimpleCompositeNumber();
        SequenceNumberHelper.get().generateInc((CompositeNumber)number, FlyDubaiHelper.class.getName(), null);
        return CARRIER_CODE + number.getNumber();
    }

    public static TravelAgentData buildTravelAgentData(SalesContext salesCtx) throws Exception {
        List orgAddresses;
        TravelAgentData data = new TravelAgentData();
        Person agent = (Person)EntityStorage.get().resolve(salesCtx.getAgent()).getEntity();
        EntityContainer orgCtr = ProfileHelper.getMainEmployment((Person)agent);
        Organization org = orgCtr != null ? (Organization)orgCtr.getEntity() : null;
        for (Communication comm : agent.getCommunications()) {
            if (CommunicationType.MOBILE.equals((Object)comm.getType()) || CommunicationType.WORK_PHONE.equals((Object)comm.getType())) {
                data.setTravelAgentMobilePhone((Communication)XCloneHelper.clone((XCloneable)comm));
            } else if (CommunicationType.HOME_PHONE.equals((Object)comm.getType())) {
                data.setTravelAgentHomePhone((Communication)XCloneHelper.clone((XCloneable)comm));
            }
            if (!CommunicationType.EMAIL.equals((Object)comm.getType())) continue;
            data.setTravelAgentEmail((Communication)XCloneHelper.clone((XCloneable)comm));
        }
        Address addr = null;
        if (agent.getAddresses().size() > 0) {
            addr = (Address)agent.getAddresses().get(0);
        } else if (org != null && (orgAddresses = ProfileHelper.getOrganizationAddresses((Organization)org)).size() > 0) {
            addr = (Address)orgAddresses.get(0);
        }
        if (addr != null) {
            data.setTravelAgentCountry(DictHelper.getTranslation((DictionaryReference)addr.getCountry(), (Locale)LocaleHelper.EN_LOCALE, (boolean)false));
            data.setTravelAgentCity(DictHelper.getTranslation((DictionaryReference)addr.getCity(), (Locale)LocaleHelper.EN_LOCALE, (boolean)false));
            data.setTravelAgentAddress1(StringUtils.substring((String)ProfileHelper.buildFullAddress((Address)addr, (Locale)LocaleHelper.EN_LOCALE, (boolean)false), (int)0, (int)ADDRESS_LENGTH));
        }
        if (org != null) {
            for (Communication comm : org.getCommunications()) {
                if (CommunicationType.MOBILE.equals((Object)comm.getType()) || CommunicationType.WORK_PHONE.equals((Object)comm.getType())) {
                    if (data.getTravelAgentMobilePhone() == null) {
                        data.setTravelAgentMobilePhone((Communication)XCloneHelper.clone((XCloneable)comm));
                    }
                } else if (CommunicationType.HOME_PHONE.equals((Object)comm.getType()) && data.getTravelAgentHomePhone() == null) {
                    data.setTravelAgentHomePhone((Communication)XCloneHelper.clone((XCloneable)comm));
                }
                if (!CommunicationType.EMAIL.equals((Object)comm.getType()) || data.getTravelAgentEmail() != null) continue;
                data.setTravelAgentEmail((Communication)XCloneHelper.clone((XCloneable)comm));
            }
        }
        if (data.getTravelAgentHomePhone() == null) {
            data.setTravelAgentHomePhone((Communication)XCloneHelper.clone((XCloneable)data.getTravelAgentMobilePhone()));
            data.getTravelAgentHomePhone().setType(CommunicationType.HOME_PHONE);
        } else if (data.getTravelAgentMobilePhone() == null) {
            data.setTravelAgentMobilePhone((Communication)XCloneHelper.clone((XCloneable)data.getTravelAgentHomePhone()));
            data.getTravelAgentMobilePhone().setType(CommunicationType.MOBILE);
        }
        return data;
    }

    public static boolean isRealDate(Date date) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        return cl.get(1) > 1;
    }

    public static boolean isRussianLocation(DictionaryReference<GeoLocation> locRef) {
        GeoLocation loc = null;
        try {
            loc = (GeoLocation)DictionaryCache.get().resolveReference(locRef);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loc == null) {
            return false;
        }
        DictionaryReference countryRef = loc.getCountry();
        return countryRef == null ? false : LOCATION_RUS_CODE.equals(countryRef.getCode());
    }

    public static boolean isRoundtrip(List<RouteSegment> list) {
        if (list.size() != 2) {
            return false;
        }
        if (!list.get(0).getLocationBegin().equals((Object)list.get(1).getLocationEnd())) {
            return false;
        }
        return list.get(0).getLocationEnd().equals((Object)list.get(1).getLocationBegin());
    }

    public static void checkWsResponse(ExceptionInformationExceptions exceptions) throws FlyDubaiResponseException {
        if (exceptions == null) {
            return;
        }
        for (ExceptionInformationException ex : exceptions.getExceptionInformationExceptionList()) {
            ExceptionLevels level = ex.getExceptionLevel();
            if (level == ExceptionLevels.SUCCESS || level != ExceptionLevels.CRITICAL) continue;
            if (ex.getExceptionDescription().contains("Invoice Payment(s) submitted is greater than the available limit")) {
                throw Xeption.forEndUser((String)"\u0418\u0441\u0447\u0435\u0440\u043f\u0430\u043d \u043b\u0438\u043c\u0438\u0442 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u0443\u0441\u043b\u0443\u0433. \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u0430/\u043a \u0437\u0430 \u043f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435\u043c \u0431\u0430\u043b\u0430\u043d\u0441\u0430", (Object[])new Object[0]);
            }
            throw new FlyDubaiResponseException("FlyDubai Response critical exception : " + ex.getExceptionDescription());
        }
    }

    public static int calcAge(Date dateOfBirth) {
        Calendar dob = Calendar.getInstance();
        dob.setTime(dateOfBirth);
        Calendar today = Calendar.getInstance();
        int age = today.get(1) - dob.get(1);
        if (today.get(6) <= dob.get(6)) {
            --age;
        }
        return age;
    }

    public static Gender getGender(String str) {
        if (TextUtil.isBlank((String)str)) {
            return null;
        }
        if (str.equals("M")) {
            return Gender.MALE;
        }
        if (str.equals("F")) {
            return Gender.FEMALE;
        }
        return null;
    }

    public static DictionaryReference<PassengerType> getPassengerType(Date birthday) {
        DictionaryReference adultPassengerType;
        DictionaryReference type = adultPassengerType = DictHelper.getAdultPassengerType();
        if (birthday == null) {
            return type;
        }
        int years = FlyDubaiHelper.calcAge(birthday);
        if (years >= 12) {
            type = adultPassengerType;
        } else if (years >= 2) {
            type = DictHelper.getChildPassengerType();
        } else if (years < 2) {
            type = DictHelper.getInfantPassengerType();
        }
        return type;
    }

    public static int getPassengerTypeInt(Date birthday) throws Exception {
        return FlyDubaiHelper.convertPassengerTypeToInt(FlyDubaiHelper.getPassengerType(birthday));
    }

    public static int convertPassengerTypeToInt(DictionaryReference<PassengerType> passengerType) {
        return Integer.parseInt(FLY_DUBAI_CODE_TRANSLATOR.getNativeCode(passengerType));
    }

    public static DictionaryReference<PassengerType> convertIntToPassengerType(int id) {
        return FLY_DUBAI_CODE_TRANSLATOR.resolveNativeCode(PassengerType.class, Integer.toString(id));
    }

    public static Date getDateWithoutTimezone(Date date) {
        Calendar originalCal = Calendar.getInstance();
        originalCal.setTime(date);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.set(originalCal.get(1), originalCal.get(2), originalCal.get(5), 0, 0, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static boolean isFakeReservation(Reservation res) {
        for (BaseProduct bp : res.getProducts()) {
            if (!(bp instanceof Product)) continue;
            return TextUtil.isBlank((String)((Product)bp).getGdsId());
        }
        return true;
    }

    public static BigDecimal round(BigDecimal value) {
        return value.setScale(0, RoundingMode.UP);
    }

    public static ClassOfService convertClassOfServiceFromGds(FareInfo fareInfo) {
        return ClassOfService.valueOf((String)fareInfo.getCabin());
    }

    public static String getRecordLocator(Reservation reservation) {
        return ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)reservation, (RecordLocatorType)RecordLocatorType.DEFAULT);
    }

    static {
        baggageTaxCodes.add("BAGB");
        baggageTaxCodes.add("BAGL");
        baggageTaxCodes.add("BAGX");
        baggageTaxCodes.add("JBAG");
        ADDRESS_LENGTH = 64;
    }
}

