/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.ibus.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.server.gds.flydubai.FlyDubaiHelper;
import com.gridnine.xtrip.server.gds.flydubai.ibus.IBusGdsFlyDubaiContextKeys;
import com.gridnine.xtrip.server.gds.flydubai.ibus.security.FlyDubaiSecurityInfo;
import com.gridnine.xtrip.server.gds.flydubai.mapping.ReservationBuilderHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.tempuri.CreatePNRResponse;

public class CommitPNRRSProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        CreatePNRResponse response = (CreatePNRResponse)ctx.getMandatoryObject((Enum)IBusGdsFlyDubaiContextKeys.FLYDUBAI_WS_RESPONSE_PAYLOAD);
        FlyDubaiHelper.checkWsResponse(response.getCreatePNRResult().getExceptions());
        ctx.putObject((Enum)IBusGdsFlyDubaiContextKeys.FLYDUBAI_WS_RESPONSE_PAYLOAD, null);
        FlyDubaiSecurityInfo secInfo = (FlyDubaiSecurityInfo)ctx.getMandatoryObject((Enum)IBusGdsFlyDubaiContextKeys.SECURITY_INFO);
        Flight flight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        Reservation reservation = ReservationBuilderHelper.createReservation(response.getCreatePNRResult(), secInfo.getTransactionFee(), flight, travellers);
        Reservation createdRes = (Reservation)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Date timelimit = response.getCreatePNRResult().getReservationFulfillmentRequiredByGMT();
        if (createdRes == null || FlyDubaiHelper.isFakeReservation(createdRes)) {
            Calendar bookDate = Calendar.getInstance();
            bookDate.setTime(response.getCreatePNRResult().getBookDate());
            bookDate.add(10, 1);
            Calendar timeLimitCal = Calendar.getInstance();
            timeLimitCal.setTime(timelimit);
            if (bookDate.after(timeLimitCal)) {
                reservation.getGdsNameInfo().getSystemInfos().clear();
            }
            reservation.setPqTimeLimit(timelimit);
            ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)reservation);
        } else {
            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)createdRes, (GdsName)GdsName.FLY_DUBAI, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)FlyDubaiHelper.getRecordLocator(reservation));
            createdRes.setResDate(reservation.getResDate());
            createdRes.setRefreshFromGdsDate(reservation.getRefreshFromGdsDate());
            createdRes.setPqTimeLimit(timelimit);
        }
    }
}

