/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.ibus.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.flydubai.FlyDubaiHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class FakeReservationBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GdsReservationCreationParameters params = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        SalesContext salesCtx = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        GDSParameters gdsParams = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        Flight flight = params.getFlight();
        Reservation res = new Reservation();
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)res, (GdsName)GdsName.FLY_DUBAI, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)FlyDubaiHelper.getFakeReservationNumber());
        Date now = new Date();
        res.setAccountCode(flight.getAccountCode());
        res.getGdsNameInfo().setOnlineGdsAccount(flight.getGdsAccount());
        res.setPricingDate(now);
        res.setResDate(now);
        res.setBookingAgent(salesCtx.getAgent());
        res.setSalesPoint(salesCtx.getSalesPoint());
        res.setSubagency(salesCtx.getSubagency());
        if (res.getSubagency() == null) {
            if (salesCtx.getAgency() != null) {
                res.setSubagency(salesCtx.getAgency());
            } else {
                try {
                    EntityContainer spCtr = EntityStorage.get().resolve(salesCtx.getSalesPoint());
                    if (spCtr != null) {
                        res.setSubagency(((SalesPoint)spCtr.getEntity()).getAgency());
                    }
                }
                catch (Exception e) {
                    this.log.error("failed loading agency", (Throwable)e);
                }
            }
        }
        for (GdsTraveller gdsTraveller : params.getGdsTravellers()) {
            Product p = this.createProduct(flight, gdsTraveller, travellers, gdsParams);
            res.getProducts().add(p);
            p.setReservation(res);
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)res);
    }

    private Product createProduct(Flight flight, GdsTraveller gdsTraveller, Collection<Traveller> travellers, GDSParameters gdsParams) throws Exception {
        Product prod = new Product();
        prod.setEticket(true);
        prod.setProductCategory(ProductCategory.AIR);
        prod.setTariffType(TariffType.REGULAR);
        prod.setCarrier(flight.getCarrier());
        prod.setPassengerType(gdsTraveller.getPassengerType());
        prod.setProductCategory(ProductCategory.AIR);
        AirProductHelper.setSalesChain((Product)prod, (SalesChain)flight.getSalesChain());
        AirProductHelper.getContractRelations((Product)prod);
        Airline carrier = (Airline)DictionaryCache.get().resolveReference(flight.getCarrier());
        if (carrier != null) {
            prod.setCarrierNumber(carrier.getAirlineNumber());
            prod.setCarrier(flight.getCarrier());
        }
        prod.setPassengerType(gdsTraveller.getPassengerType());
        HashMap fareInfos = new HashMap();
        int segInd = 0;
        HashMap<FlightSegmentTariff, SegmentTariff> segmentTariffs = new HashMap<FlightSegmentTariff, SegmentTariff>();
        for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
            SegmentTariff st = new SegmentTariff();
            for (FlightSegment fs : fst.getSegments()) {
                ++segInd;
                Segment seg = new Segment();
                seg.setAirline(fs.getAirline());
                seg.setArriveLocation(fs.getLocationEnd());
                seg.setArriveTerminal("");
                seg.setClassOfSvcCode(fs.getBookingClass());
                seg.setDepartureLocation(fs.getLocationBegin());
                seg.setDepartTerminal("");
                seg.setBoard(fs.getBoard());
                seg.setFlightDuration(Integer.valueOf(fs.getTravelDuration()));
                seg.setFlightNo(fs.getFlightNumber());
                seg.setStarting(fs.isStarting());
                seg.setStartDate(fs.getDateBegin());
                seg.setEndDate(fs.getDateEnd());
                seg.setNoOfStops(Integer.valueOf(fs.getStops()));
                seg.setCodeShareCarrier(fs.getOperatingAirline());
                seg.setCodeShare(!seg.getAirline().equals((Object)seg.getCodeShareCarrier()));
                this.updateSegmentFareInfo(prod, seg, fs.getFareInfos());
                seg.setNotValidBefore(seg.getStartDate());
                seg.setNotValidAfter(seg.getEndDate());
                st.getSegments().add(seg);
            }
            prod.getSegmentTariffs().add(st);
            segmentTariffs.put(fst, st);
        }
        prod.setTraveller((Traveller)CollectionUtil.find(travellers, (String)gdsTraveller.getTravellerUid()));
        for (FlightFare ffare : flight.getFares()) {
            if (!ffare.getPassengerType().equals((Object)gdsTraveller.getPassengerType())) continue;
            ProductFare fare = new ProductFare();
            fare.setBaseFare(ffare.getBaseAmount());
            fare.setEquivalentFare(ffare.getEquivalentAmount());
            fare.setSegmentTariff((SegmentTariff)segmentTariffs.get(ffare.getSegmentTariff()));
            prod.getFares().add(fare);
        }
        for (FlightTax fTax : flight.getTaxes()) {
            if (!fTax.getPassengerType().equals((Object)gdsTraveller.getPassengerType())) continue;
            Tax tax = new Tax();
            tax.setAmount(fTax.getBaseAmount());
            tax.setEquivalentAmount(fTax.getEquivalentAmount());
            tax.setSegmentTariff((SegmentTariff)segmentTariffs.get(fTax.getSegmentTariff()));
            tax.setCode(fTax.getCode());
            prod.getTaxes().add(tax);
        }
        return prod;
    }

    private void updateSegmentFareInfo(Product prod, Segment seg, List<FareInfo> fareInfos) {
        for (FareInfo fareInfo : fareInfos) {
            if (!prod.getPassengerType().equals((Object)fareInfo.getPassengerType())) continue;
            seg.setFareBasis(fareInfo.getFareBasis());
            seg.setRemarksSearchContext(fareInfo.getRemarksSearchContext());
            seg.setLuggageInfo(fareInfo.getLuggageInfo());
            return;
        }
    }
}

