/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.ibus.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.server.gds.flydubai.ibus.FlyDubaiWsMethod;
import com.gridnine.xtrip.server.gds.flydubai.ibus.IBusGdsFlyDubaiContextKeys;
import com.gridnine.xtrip.server.gds.flydubai.ibus.security.FlyDubaiSecurityInfo;
import com.gridnine.xtrip.server.gds.flydubai.mapping.ModelToFlyDubaiConverter;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsCurrencyCodeTypes;
import org.datacontract.schemas.radixx.connectpoint.reservation.ArrayOfPayment;
import org.datacontract.schemas.radixx.connectpoint.reservation.Person;
import org.datacontract.schemas.radixx.connectpoint.reservation.SummaryPNR;
import org.datacontract.schemas.radixx.connectpoint.reservation.SummaryPNRActionTypes;

public class SummaryPNRRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        org.tempuri.SummaryPNR request = this.buildRequest(ctx);
        ctx.putObject((Enum)IBusGdsFlyDubaiContextKeys.FLYDUBAI_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IBusGdsFlyDubaiContextKeys.FLYDUBAI_WS_REQUEST_METHOD, (Object)FlyDubaiWsMethod.SummaryPNR);
    }

    private org.tempuri.SummaryPNR buildRequest(MessageContext ctx) throws Exception {
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        FlyDubaiSecurityInfo securityInfo = (FlyDubaiSecurityInfo)ctx.getMandatoryObject((Enum)IBusGdsFlyDubaiContextKeys.SECURITY_INFO);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        org.tempuri.SummaryPNR request = new org.tempuri.SummaryPNR();
        SummaryPNR data = new SummaryPNR();
        data.setSecurityGUID(securityInfo.getSecurityGuid());
        data.setCarrierCodes(ModelToFlyDubaiConverter.buildCarrierCodes());
        data.setClientIPAddress("");
        data.setHistoricUserName("");
        data.setActionType(SummaryPNRActionTypes.GET_SUMMARY);
        data.setReservationInfo(ModelToFlyDubaiConverter.createReservationInfo(null));
        data.setSecurityToken(data.getSecurityGUID());
        data.setCarrierCurrency(EnumerationsCurrencyCodeTypes.RUB);
        data.setDisplayCurrency(EnumerationsCurrencyCodeTypes.RUB);
        data.setIATANum(securityInfo.getIataNumber());
        data.setUser(securityInfo.getUserName());
        data.setReceiptLanguageID("1");
        data.setPromoCode("");
        data.setExternalBookingID("");
        data.setAddress(ModelToFlyDubaiConverter.createAddress(salesContext));
        data.setContactInfos(ModelToFlyDubaiConverter.createAgentContactInfos(-214, salesContext));
        data.setPassengers(ModelToFlyDubaiConverter.createPassengers(parameters.getGdsTravellers(), travellers, salesContext));
        data.setPayments(new ArrayOfPayment());
        data.getPayments().getPaymentList().add(ModelToFlyDubaiConverter.createDefPayment());
        int primaryPersonOrgId = 0;
        for (Person p : data.getPassengers().getPersonList()) {
            if (!p.isIsPrimaryPassenger()) continue;
            primaryPersonOrgId = p.getPersonOrgID();
            break;
        }
        data.setSegments(ModelToFlyDubaiConverter.createSegments(data.getPassengers(), flight.getSegmentTariffs(), primaryPersonOrgId));
        request.setSummaryPnrRequest(data);
        return request;
    }
}

