/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.ibus.searchFlights;

import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class AreFlightSearchParametersApplicableProvider
extends BaseRoutingKeyProvider {
    private static final String DUBAI_AIRPORT_CODE = "DXB";

    public String getRoutingKey(MessageContext ctx) throws Exception {
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        if (fsp.isSkipConnected()) {
            boolean isDubaiInRoute = false;
            for (RouteSegment rs : fsp.getRoute()) {
                if (DUBAI_AIRPORT_CODE.equals(((GeoLocation)DictionaryCache.get().resolveReference(rs.getLocationBegin())).getCodeVariants().get(CodeSystem.IATA.name()))) {
                    isDubaiInRoute = true;
                    break;
                }
                if (!DUBAI_AIRPORT_CODE.equals(((GeoLocation)DictionaryCache.get().resolveReference(rs.getLocationEnd())).getCodeVariants().get(CodeSystem.IATA.name()))) continue;
                isDubaiInRoute = true;
                break;
            }
            if (!isDubaiInRoute) {
                return Boolean.toString(false);
            }
        }
        return Boolean.toString(true);
    }
}

