/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.ibus.searchFlights;

import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.server.gds.flydubai.FlyDubaiHelper;
import com.gridnine.xtrip.server.gds.flydubai.ibus.FlyDubaiWsMethod;
import com.gridnine.xtrip.server.gds.flydubai.ibus.IBusGdsFlyDubaiContextKeys;
import com.gridnine.xtrip.server.gds.flydubai.ibus.security.FlyDubaiSecurityInfo;
import com.gridnine.xtrip.server.gds.flydubai.mapping.ModelToFlyDubaiConverter;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsCurrencyCodeTypes;
import org.datacontract.schemas.radixx.connectpoint.pricing.EnumsFareFilterMethodType;
import org.datacontract.schemas.radixx.connectpoint.pricing.EnumsFareGroupMethodType;
import org.datacontract.schemas.radixx.connectpoint.pricing.EnumsInventoryFilterMethodType;
import org.datacontract.schemas.radixx.connectpoint.pricing.request.ArrayOfFareQuoteDetail;
import org.datacontract.schemas.radixx.connectpoint.pricing.request.ArrayOfFareQuoteRequestInfo;
import org.datacontract.schemas.radixx.connectpoint.pricing.request.FareQuoteDetail;
import org.datacontract.schemas.radixx.connectpoint.pricing.request.FareQuoteRequestInfo;
import org.datacontract.schemas.radixx.connectpoint.pricing.request.RetrieveFareQuote;

public class RetrieveFareQuoteRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        org.tempuri.RetrieveFareQuote request = this.buildRequest(ctx);
        ctx.putObject((Enum)IBusGdsFlyDubaiContextKeys.FLYDUBAI_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IBusGdsFlyDubaiContextKeys.FLYDUBAI_WS_REQUEST_METHOD, (Object)FlyDubaiWsMethod.RetrieveFareQuote);
    }

    private org.tempuri.RetrieveFareQuote buildRequest(MessageContext ctx) throws Exception {
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        Map routeParams = (Map)ctx.getObject((Enum)IBusGdsContextKeys.SEARCH_FLIGHTS_AIRPORTS);
        org.tempuri.RetrieveFareQuote request = new org.tempuri.RetrieveFareQuote();
        RetrieveFareQuote data = new RetrieveFareQuote();
        FlyDubaiSecurityInfo securityInfo = (FlyDubaiSecurityInfo)ctx.getMandatoryObject((Enum)IBusGdsFlyDubaiContextKeys.SECURITY_INFO);
        data.setSecurityGUID(securityInfo.getSecurityGuid());
        data.setCarrierCodes(ModelToFlyDubaiConverter.buildCarrierCodes());
        data.setHistoricUserName(securityInfo.getUserName());
        data.setPromotionalCode("");
        data.setCurrencyOfFareQuote(EnumerationsCurrencyCodeTypes.RUB);
        data.setIataNumberOfRequestor(securityInfo.getIataNumber());
        data.setCorporationID(-214);
        request.setRetrieveFareQuoteRequest(data);
        data.setFareFilterMethod(EnumsFareFilterMethodType.NO_COMBINABILITY_ROUNDTRIP_LOWEST_FARE_PER_FARE_TYPE);
        data.setFareGroupMethod(EnumsFareGroupMethodType.WEB_FARE_TYPES);
        data.setInventoryFilterMethod(EnumsInventoryFilterMethodType.AVAILABLE);
        ArrayOfFareQuoteDetail details = new ArrayOfFareQuoteDetail();
        for (RouteSegment segment : fsp.getRoute()) {
            FareQuoteDetail detail = new FareQuoteDetail();
            Pair route = (Pair)routeParams.get(segment);
            detail.setOrigin((String)route.getFirst());
            detail.setDestination((String)route.getLast());
            detail.setDateOfDeparture(FlyDubaiHelper.getDateWithoutTimezone(segment.getDate()));
            detail.setFareTypeCategory(1);
            detail.setFareClass("");
            detail.setFareBasisCode("");
            detail.setCabin(fsp.getServiceClass() != null ? fsp.getServiceClass().name() : "");
            detail.setOperatingCarrierCode("FZ");
            detail.setMarketingCarrierCode("FZ");
            Integer matrixSize = (Integer)ctx.getObject((Enum)IBusGdsContextKeys.MATRIX_SIZE);
            detail.setNumberOfDaysAfter(matrixSize != null ? matrixSize : 0);
            detail.setNumberOfDaysBefore(matrixSize != null ? matrixSize : 0);
            detail.setLanguageCode("en");
            detail.setTicketPackageID("1");
            detail.setLFID(-214);
            ArrayOfFareQuoteRequestInfo infos = new ArrayOfFareQuoteRequestInfo();
            for (SeatPreferences seat : fsp.getSeats()) {
                FareQuoteRequestInfo info = new FareQuoteRequestInfo();
                info.setTotalSeatsRequired(seat.getCount());
                info.setPassengerTypeID(FlyDubaiHelper.convertPassengerTypeToInt((DictionaryReference<PassengerType>)seat.getPassengerType()));
                infos.getFareQuoteRequestInfoList().add(info);
            }
            detail.setFareQuoteRequestInfos(infos);
            details.getFareQuoteDetailList().add(detail);
        }
        data.setFareQuoteDetails(details);
        return request;
    }
}

