/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.ibus.searchFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.BaseGDSEntity;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.flydubai.FlyDubaiHelper;
import com.gridnine.xtrip.server.gds.flydubai.ibus.IBusGdsFlyDubaiContextKeys;
import com.gridnine.xtrip.server.gds.flydubai.ibus.security.FlyDubaiSecurityInfo;
import com.gridnine.xtrip.server.gds.flydubai.mapping.FlightsBuilderHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.datacontract.schemas.radixx.connectpoint.pricing.ArrayOfFareType;
import org.datacontract.schemas.radixx.connectpoint.pricing.ArrayOfFlightLegDetail;
import org.datacontract.schemas.radixx.connectpoint.pricing.FareType;
import org.datacontract.schemas.radixx.connectpoint.pricing.FlightLegDetail;
import org.datacontract.schemas.radixx.connectpoint.pricing.FlightSegment;
import org.datacontract.schemas.radixx.connectpoint.pricing.LegDetail;
import org.datacontract.schemas.radixx.connectpoint.pricing.ViewFareQuote;
import org.tempuri.RetrieveFareQuoteResponse;

public class RetrieveFareQuoteRSProcessor
extends BaseProcessor {
    private static final int DEFAULT_FLIGHTS_LIMIT = 200;

    public void process(MessageContext ctx) throws Exception {
        RetrieveFareQuoteResponse response = (RetrieveFareQuoteResponse)ctx.getMandatoryObject((Enum)IBusGdsFlyDubaiContextKeys.FLYDUBAI_WS_RESPONSE_PAYLOAD);
        GDSParameters gdsParams = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        ArrayList<Flight> flights = (ArrayList<Flight>)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHTS);
        if (flights == null) {
            flights = new ArrayList<Flight>();
        }
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        ctx.putObject((Enum)IBusGdsFlyDubaiContextKeys.FLYDUBAI_WS_RESPONSE_PAYLOAD, null);
        ViewFareQuote view = response.getRetrieveFareQuoteResult();
        int flightLimit = 200;
        Boolean flightAllFares = (Boolean)ctx.getObject((Enum)IBusGdsFlyDubaiContextKeys.FLIGHT_ALL_FARES);
        boolean affFares = flightAllFares == null ? false : flightAllFares;
        if (affFares) {
            Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
            this.editViewFareQuote(view, flight);
            flightLimit = 50;
        }
        if (view != null) {
            flights.addAll(FlightsBuilderHelper.createFlights(view, fsp, gdsParams, (GdsTracingItemBuilder<Flight>)builder, isSaveRulesTraces, flightLimit, affFares));
            for (Flight flight : flights) {
                this.saveSecurityInfo((BaseGDSEntity)flight, ctx);
            }
        }
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHTS, flights);
    }

    protected void saveSecurityInfo(BaseGDSEntity flight, MessageContext ctx) {
        FlyDubaiSecurityInfo.saveSecurityInfo(flight, ctx);
    }

    private void editViewFareQuote(ViewFareQuote view, Flight flight) {
        List<FlightSegment> flightSegmentList = this.filterFareQuote(view, flight);
        ArrayList flightSegmentWithOneFareTypeList = new ArrayList();
        for (FlightSegment fs : flightSegmentList) {
            fs.getFareTypes().getFareTypeList().forEach(ft -> flightSegmentWithOneFareTypeList.add(this.cloneFlightSegment(fs, (FareType)ft)));
        }
        view.getFlightSegments().getFlightSegmentList().clear();
        view.getFlightSegments().getFlightSegmentList().addAll(flightSegmentWithOneFareTypeList);
    }

    private List<FlightSegment> filterFareQuote(ViewFareQuote view, Flight flight) {
        ArrayList<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();
        Map PFIDsFlightSegmentMap = view.getFlightSegments().getFlightSegmentList().stream().collect(Collectors.toMap(fs -> fs.getFlightLegDetails().getFlightLegDetailList().stream().map(FlightLegDetail::getPFID).collect(Collectors.toSet()), Function.identity()));
        List<List<com.gridnine.xtrip.common.gds.model.FlightSegment>> legs = this.getFlightLegs(flight);
        for (List<com.gridnine.xtrip.common.gds.model.FlightSegment> leg : legs) {
            HashSet PFIDs = new HashSet();
            for (com.gridnine.xtrip.common.gds.model.FlightSegment flightSegment : leg) {
                view.getLegDetails().getLegDetailList().stream().filter(det -> det.getFlightNum().equals(flightSegment.getFlightNumber())).filter(det2 -> FlightsBuilderHelper.correctTime(det2.getDepartureDate()).equals(flightSegment.getDateBegin())).filter(det3 -> FlyDubaiHelper.resolveNativeCode(GeoLocation.class, det3.getOrigin().trim()).equals((Object)flightSegment.getLocationBegin())).filter(det4 -> FlyDubaiHelper.resolveNativeCode(GeoLocation.class, det4.getDestination().trim()).equals((Object)flightSegment.getLocationEnd())).map(LegDetail::getPFID).forEach(PFIDs::add);
            }
            if (PFIDs.size() != leg.size()) {
                throw Xeption.forDeveloper((String)String.format("Some of this segments where not found: %s", TextUtil.join((String)",", (Iterable)leg.stream().map(seg -> String.format("%s -> %s", seg.getLocationBegin().getCode(), seg.getLocationEnd().getCode())).collect(Collectors.toList()))), (Object[])new Object[0]);
            }
            flightSegmentList.add((FlightSegment)PFIDsFlightSegmentMap.get(PFIDs));
        }
        return flightSegmentList;
    }

    private FlightSegment cloneFlightSegment(FlightSegment fs, FareType ft) {
        FlightSegment flightSegment = new FlightSegment();
        flightSegment.setLFID(fs.getLFID());
        flightSegment.setArrivalDate(fs.getArrivalDate());
        flightSegment.setDepartureDate(fs.getDepartureDate());
        flightSegment.setLegCount(fs.getLegCount());
        flightSegment.setInternational(fs.isInternational());
        ArrayList<FareType> fareTypeList = new ArrayList<FareType>();
        fareTypeList.add(ft);
        ArrayOfFareType fareTypes = new ArrayOfFareType();
        fareTypes.setFareTypeList(fareTypeList);
        flightSegment.setFareTypes(fareTypes);
        ArrayList flightLegDetailList = new ArrayList(fs.getFlightLegDetails().getFlightLegDetailList());
        ArrayOfFlightLegDetail flightLegDetails = new ArrayOfFlightLegDetail();
        flightLegDetails.setFlightLegDetailList(flightLegDetailList);
        flightSegment.setFlightLegDetails(flightLegDetails);
        return flightSegment;
    }

    private List<List<com.gridnine.xtrip.common.gds.model.FlightSegment>> getFlightLegs(Flight flight) {
        ArrayList<List<com.gridnine.xtrip.common.gds.model.FlightSegment>> legs = new ArrayList<List<com.gridnine.xtrip.common.gds.model.FlightSegment>>();
        for (com.gridnine.xtrip.common.gds.model.FlightSegment segment : FlightHelper.getSegments((Flight)flight)) {
            List<com.gridnine.xtrip.common.gds.model.FlightSegment> legSegments;
            if (segment.isStarting()) {
                legSegments = new ArrayList();
                legs.add(legSegments);
            } else {
                legSegments = (List)legs.get(legs.size() - 1);
            }
            legSegments.add(segment);
        }
        return legs;
    }
}

