/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.ibus.searchSimpleMatrix;

import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.model.SimpleMatrixElement;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.flydubai.FlyDubaiHelper;
import com.gridnine.xtrip.server.gds.flydubai.ibus.IBusGdsFlyDubaiContextKeys;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datacontract.schemas.radixx.connectpoint.pricing.BaseFareInfo;
import org.datacontract.schemas.radixx.connectpoint.pricing.FareInfo;
import org.datacontract.schemas.radixx.connectpoint.pricing.FareType;
import org.datacontract.schemas.radixx.connectpoint.pricing.FlightSegment;
import org.datacontract.schemas.radixx.connectpoint.pricing.ViewFareQuote;
import org.tempuri.RetrieveFareQuoteResponse;

public class RetrieveFareQuoteSimpleMatrixRSProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RetrieveFareQuoteResponse response = (RetrieveFareQuoteResponse)ctx.getMandatoryObject((Enum)IBusGdsFlyDubaiContextKeys.FLYDUBAI_WS_RESPONSE_PAYLOAD);
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        ArrayList simpleMatrix = new ArrayList();
        ViewFareQuote view = response.getRetrieveFareQuoteResult();
        Map<Integer, Integer> paxTypeCode2Quantity = this.buildPaxTypeCode2Quantity(fsp);
        String gdsCurrencyCode = view.getRequestedCurrencyOfFareQuote();
        List<List<FlightSegment>> variants = this.getVariants(view);
        variants.forEach(fs -> simpleMatrix.add(this.buildSimpleMatrixElement((List<FlightSegment>)fs, paxTypeCode2Quantity, gdsCurrencyCode)));
        ctx.putObject((Enum)IBusGdsContextKeys.SIMPLE_MATRIX, simpleMatrix);
    }

    private List<List<FlightSegment>> getVariants(ViewFareQuote view) {
        ArrayList<List<FlightSegment>> variants = new ArrayList<List<FlightSegment>>();
        ArrayList flightSegmentsFirst = new ArrayList();
        ArrayList flightSegmentsSecond = new ArrayList();
        view.getFlightSegments().getFlightSegmentList().forEach(seg -> {
            if (seg.getLegCount() == 1) {
                flightSegmentsFirst.add(seg);
            } else if (seg.getLegCount() == 2) {
                flightSegmentsSecond.add(seg);
            }
        });
        if (flightSegmentsSecond.isEmpty()) {
            flightSegmentsFirst.forEach(fs -> {
                ArrayList<FlightSegment> list = new ArrayList<FlightSegment>();
                list.add((FlightSegment)fs);
                variants.add(list);
            });
        } else {
            variants.addAll(CollectionUtil.cartesianProduct(Arrays.asList(flightSegmentsFirst, flightSegmentsSecond)));
        }
        return variants;
    }

    private Money getPrice(List<FlightSegment> gdsSegments, Map<Integer, Integer> paxTypeCode2Quantity, String gdsCurrencyCode) {
        BigDecimal sum = BigDecimal.ZERO;
        for (FlightSegment gdsSegment : gdsSegments) {
            FareType minFare = gdsSegment.getFareTypes().getFareTypeList().stream().min(Comparator.comparing(fareType -> fareType.getFareInfos().getFareInfoList().stream().map(BaseFareInfo::getBaseFareAmtInclTax).min(Comparator.naturalOrder()).get())).get();
            for (FareInfo fi : minFare.getFareInfos().getFareInfoList()) {
                sum = sum.add(fi.getBaseFareAmtInclTax().multiply(BigDecimal.valueOf(paxTypeCode2Quantity.get(fi.getPTCID()).intValue())));
            }
        }
        Money amount = new Money();
        amount.setValue(FlyDubaiHelper.round(sum));
        amount.setCurrency(gdsCurrencyCode);
        return amount;
    }

    private Map<Integer, Integer> buildPaxTypeCode2Quantity(FlightSearchParameters fsp) {
        HashMap<Integer, Integer> paxTypeCode2Quantity = new HashMap<Integer, Integer>();
        for (SeatPreferences sp : fsp.getSeats()) {
            paxTypeCode2Quantity.put(FlyDubaiHelper.convertPassengerTypeToInt((DictionaryReference<PassengerType>)sp.getPassengerType()), sp.getCount());
        }
        return paxTypeCode2Quantity;
    }

    private SimpleMatrixElement buildSimpleMatrixElement(List<FlightSegment> gdsSegments, Map<Integer, Integer> paxTypeCode2Quantity, String gdsCurrencyCode) {
        FlightSegment gdsSegment1 = gdsSegments.get(0);
        SimpleMatrixElement simpleMatrixElement = new SimpleMatrixElement();
        simpleMatrixElement.setBestPrice(this.getPrice(gdsSegments, paxTypeCode2Quantity, gdsCurrencyCode));
        simpleMatrixElement.setDateFrom(MiscUtil.toLocalDate((Date)gdsSegment1.getDepartureDate()));
        if (gdsSegments.size() == 2) {
            simpleMatrixElement.setDateTo(MiscUtil.toLocalDate((Date)gdsSegments.get(1).getDepartureDate()));
        }
        return simpleMatrixElement;
    }
}

