/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.ibus.security;

import com.gridnine.xtrip.common.gds.model.BaseGDSEntity;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.server.gds.flydubai.ibus.IBusGdsFlyDubaiContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Collection;

public class FlyDubaiSecurityInfo {
    private static final String PROP_SECURITY_GUID = "securityGuid";
    private static final String PROP_USERNAME = "userName";
    private static final String PROP_IATA_NUMBER = "iataNumber";
    private static final String PROP_TFEE = "tfee";
    private String securityGuid;
    private String userName;
    private String iataNumber;
    private BigDecimal transactionFee;

    private FlyDubaiSecurityInfo() {
    }

    public static FlyDubaiSecurityInfo createSecurityInfo(MessageContext ctx) {
        FlyDubaiSecurityInfo info = new FlyDubaiSecurityInfo();
        info.setSecurityGuid((String)ctx.getMandatoryObject((Enum)IBusGdsFlyDubaiContextKeys.SECURITY_GUID));
        info.setIataNumber((String)ctx.getMandatoryObject((Enum)IBusGdsFlyDubaiContextKeys.IATA_NUMBER));
        info.setUserName((String)ctx.getMandatoryObject((Enum)IBusGdsFlyDubaiContextKeys.USER_LOGIN));
        info.setTransactionFee((BigDecimal)ctx.getMandatoryObject((Enum)IBusGdsFlyDubaiContextKeys.TFEE));
        return info;
    }

    public static void saveSecurityInfo(BaseGDSEntity entity, MessageContext ctx) {
        FlyDubaiSecurityInfo.saveSecurityInfo(entity, FlyDubaiSecurityInfo.createSecurityInfo(ctx));
    }

    public static void saveSecurityInfo(BaseGDSEntity entity, FlyDubaiSecurityInfo info) {
        entity.getCustomProperties().add(NamedValueHelper.namedValue((String)PROP_SECURITY_GUID, (String)info.getSecurityGuid()));
        entity.getCustomProperties().add(NamedValueHelper.namedValue((String)PROP_USERNAME, (String)info.getUserName()));
        entity.getCustomProperties().add(NamedValueHelper.namedValue((String)PROP_IATA_NUMBER, (String)info.getIataNumber()));
        entity.getCustomProperties().add(NamedValueHelper.namedValue((String)PROP_TFEE, (String)info.getTransactionFee().toString()));
    }

    public static FlyDubaiSecurityInfo getSecurityInfo(BaseGDSEntity entity) {
        FlyDubaiSecurityInfo info = new FlyDubaiSecurityInfo();
        info.setIataNumber(NamedValueHelper.getValueForName((String)PROP_IATA_NUMBER, (Collection)entity.getCustomProperties()));
        info.setUserName(NamedValueHelper.getValueForName((String)PROP_USERNAME, (Collection)entity.getCustomProperties()));
        info.setSecurityGuid(NamedValueHelper.getValueForName((String)PROP_SECURITY_GUID, (Collection)entity.getCustomProperties()));
        info.setTransactionFee(new BigDecimal(NamedValueHelper.getValueForName((String)PROP_TFEE, (Collection)entity.getCustomProperties())));
        return info;
    }

    public String getSecurityGuid() {
        return this.securityGuid;
    }

    public void setSecurityGuid(String securityGuid) {
        this.securityGuid = securityGuid;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getIataNumber() {
        return this.iataNumber;
    }

    public void setIataNumber(String iataNumber) {
        this.iataNumber = iataNumber;
    }

    public BigDecimal getTransactionFee() {
        return this.transactionFee;
    }

    public void setTransactionFee(BigDecimal transactionFee) {
        this.transactionFee = transactionFee;
    }
}

