/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.ibus.selectFlight;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.server.gds.flydubai.ibus.IBusGdsFlyDubaiContextKeys;
import com.gridnine.xtrip.server.gds.flydubai.ibus.security.FlyDubaiSecurityInfo;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;

public class FindActualFlightProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Flight found = null;
        for (Flight fl : flights) {
            if (!this.flightEquals(flight, fl)) continue;
            found = fl;
            break;
        }
        if (found == null) {
            throw Xeption.forEndUser((String)"\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u043c\u0443 \u043f\u0435\u0440\u0435\u043b\u0435\u0442\u0443 \u043d\u0435\u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u044b, \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u043f\u043e\u0438\u0441\u043a \u0435\u0449\u0435 \u0440\u0430\u0437.", (Object[])new Object[0]);
        }
        FlyDubaiSecurityInfo secInfo = (FlyDubaiSecurityInfo)ctx.getMandatoryObject((Enum)IBusGdsFlyDubaiContextKeys.SECURITY_INFO);
        FlyDubaiSecurityInfo.saveSecurityInfo(found, secInfo);
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)found);
    }

    private boolean flightEquals(Flight fl1, Flight fl2) {
        if (fl1.getSegmentTariffs().size() != fl2.getSegmentTariffs().size()) {
            return false;
        }
        for (int q = 0; q < fl1.getSegmentTariffs().size(); ++q) {
            if (this.flightSegmentsTariffEquals((FlightSegmentTariff)fl1.getSegmentTariffs().get(q), (FlightSegmentTariff)fl2.getSegmentTariffs().get(q))) continue;
            return false;
        }
        if (fl1.getFares().size() != fl2.getFares().size() || fl1.getTaxes().size() != fl2.getTaxes().size()) {
            return false;
        }
        for (FlightFare fare : fl1.getFares()) {
            if (this.containsFare(fl2.getFares(), fare)) continue;
            return false;
        }
        for (FlightTax tax : fl1.getTaxes()) {
            if (this.containsTax(fl2.getTaxes(), tax)) continue;
            return false;
        }
        return true;
    }

    private boolean containsFare(Collection<FlightFare> fares, FlightFare fare) {
        String fareCode = NamedValueHelper.getValueForName((String)"flydubai-fare-code", (Collection)fare.getCustomProperties());
        for (FlightFare el : fares) {
            String elFareCode = NamedValueHelper.getValueForName((String)"flydubai-fare-code", (Collection)el.getCustomProperties());
            if (!el.getBaseAmount().getValue().equals(fare.getBaseAmount().getValue()) || !elFareCode.equals(fareCode)) continue;
            return true;
        }
        return false;
    }

    private boolean containsTax(Collection<FlightTax> taxes, FlightTax tax) {
        for (FlightTax el : taxes) {
            if (el.getBaseAmount().getValue().doubleValue() != tax.getBaseAmount().getValue().doubleValue() || !el.getCode().trim().equals(tax.getCode().trim())) continue;
            return true;
        }
        return false;
    }

    private boolean flightSegmentsTariffEquals(FlightSegmentTariff fst1, FlightSegmentTariff fst2) {
        int size = fst1.getSegments().size();
        if (size != fst2.getSegments().size()) {
            return false;
        }
        for (int q = 0; q < size; ++q) {
            FlightSegment seg1 = (FlightSegment)fst1.getSegments().get(q);
            FlightSegment seg2 = (FlightSegment)fst2.getSegments().get(q);
            if (seg1.getDateBegin().equals(seg2.getDateBegin()) && seg1.getDateEnd().equals(seg2.getDateEnd()) && seg1.getLocationBegin().equals((Object)seg2.getLocationBegin()) && seg1.getLocationEnd().equals((Object)seg2.getLocationEnd())) continue;
            return false;
        }
        return true;
    }
}

