/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.ibus.setApisInfo;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.flydubai.model.FlyDubaiGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.gds.flydubai.FlyDubaiHelper;
import com.gridnine.xtrip.server.gds.flydubai.ibus.FlyDubaiWsMethod;
import com.gridnine.xtrip.server.gds.flydubai.ibus.IBusGdsFlyDubaiContextKeys;
import com.gridnine.xtrip.server.gds.flydubai.ibus.security.FlyDubaiSecurityInfo;
import com.gridnine.xtrip.server.gds.flydubai.ibus.setApisInfo.ApisInfo;
import com.gridnine.xtrip.server.gds.flydubai.ibus.setApisInfo.ApisInfoXML;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.tempuri.SetApisInfo;
import org.w3c.dom.Document;

public class SetApisInfoRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FlyDubaiSecurityInfo securityInfo = (FlyDubaiSecurityInfo)ctx.getMandatoryObject((Enum)IBusGdsFlyDubaiContextKeys.SECURITY_INFO);
        SetApisInfo req = new SetApisInfo();
        req.setSessionKey(securityInfo.getSecurityGuid());
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        req.setCheckinAgent(((FlyDubaiGdsAccount)accountCtr.getEntity()).getAccount());
        req.setSeriesNum("299");
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        req.setConfirmationNum(FlyDubaiHelper.getRecordLocator(res));
        ApisInfoXML apisInfoXml = this.buildApisInfoXML(res);
        Document doc = DocumentBuilderHelper.newDocument();
        apisInfoXml.toXml(doc);
        StreamResult result = new StreamResult(new StringWriter());
        Transformer tr = XUtil.newTransformer();
        tr.setOutputProperty("omit-xml-declaration", "no");
        tr.setOutputProperty("encoding", "utf-8");
        tr.transform(new DOMSource(doc), result);
        req.setApisInfoXML(result.getWriter().toString());
        ctx.putObject((Enum)IBusGdsFlyDubaiContextKeys.FLYDUBAI_WS_REQUEST_PAYLOAD, (Object)req);
        ctx.putObject((Enum)IBusGdsFlyDubaiContextKeys.FLYDUBAI_WS_REQUEST_METHOD, (Object)FlyDubaiWsMethod.SetApisInfo);
    }

    private ApisInfoXML buildApisInfoXML(Reservation res) {
        ApisInfoXML infoXml = new ApisInfoXML();
        int recNumber = 0;
        int apiInfoIndex = -1;
        List tariffs = new ArrayList();
        for (BaseProduct bp : res.getProducts()) {
            if (!(bp instanceof Product)) continue;
            tariffs = ((Product)bp).getSegmentTariffs();
        }
        for (SegmentTariff st : tariffs) {
            Product p;
            for (BaseProduct bp : res.getProducts()) {
                if (!(bp instanceof Product) || !DictHelper.isAdultPassengerType((DictionaryReference)(p = (Product)bp).getPassengerType())) continue;
                ++recNumber;
                for (Segment seg : st.getSegments()) {
                    infoXml.getInfos().add(this.buildApisInfo(p, recNumber, --apiInfoIndex, seg));
                }
            }
            for (BaseProduct bp : res.getProducts()) {
                if (!(bp instanceof Product) || DictHelper.isAdultPassengerType((DictionaryReference)(p = (Product)bp).getPassengerType())) continue;
                ++recNumber;
                for (Segment seg : st.getSegments()) {
                    infoXml.getInfos().add(this.buildApisInfo(p, recNumber, --apiInfoIndex, seg));
                }
            }
        }
        return infoXml;
    }

    private ApisInfo buildApisInfo(Product p, int recNumber, int apiInfoIndex, Segment seg) {
        ApisInfo info = new ApisInfo();
        info.setIndex(apiInfoIndex);
        info.setSeriesNum("299");
        info.setConfirmationNumber(FlyDubaiHelper.getRecordLocator(p.getReservation()));
        info.setRecordNumber(recNumber);
        info.setStatus("FL");
        Passport passport = p.getTraveller().getPassport();
        info.setLastName(passport.getLastName());
        info.setFirstName(passport.getFirstName());
        info.setMiddleName(passport.getMiddleName() != null ? passport.getMiddleName() : "");
        info.setBirthDate(passport.getBirthday());
        if (passport.getGender().equals((Object)Gender.MALE)) {
            info.setGender("M");
        } else {
            info.setGender("F");
        }
        info.setCitizenship(FlyDubaiHelper.getNativeCode(passport.getCitizenship()));
        info.setDocumentType("1");
        info.setDocumentNumber(passport.getNumber());
        info.setIssueCountry(FlyDubaiHelper.getNativeCode(passport.getOriginCountry()));
        info.setExpiryDate(passport.getExpired());
        info.setResultCode("0");
        info.setDocumentType2("0");
        info.setPhysicalFlightId(seg.getGdsId());
        info.setActualDepartDate(seg.getStartDate());
        info.setFlightNumber(seg.getFlightNo());
        info.setEmbarkation(FlyDubaiHelper.getNativeCode(seg.getDepartureLocation()));
        info.setDebarkation(FlyDubaiHelper.getNativeCode(seg.getArriveLocation()));
        info.setArrival(FlyDubaiHelper.getNativeCode(seg.getArriveLocation()));
        info.setDocumentScanned1("0");
        info.setDocumentScanned2("0");
        return info;
    }
}

