/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.ibus.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class CreateSearchParamsFromReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        FlightSearchParameters searchParams = new FlightSearchParameters();
        Product pr = (Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0);
        for (SegmentTariff tariff : pr.getSegmentTariffs()) {
            RouteSegment route = new RouteSegment();
            int lastIndex = tariff.getSegments().size() - 1;
            route.setLocationBegin(((Segment)tariff.getSegments().get(0)).getDepartureLocation());
            route.setLocationEnd(((Segment)tariff.getSegments().get(lastIndex)).getArriveLocation());
            route.setDate(((Segment)tariff.getSegments().get(0)).getStartDate());
            searchParams.getRoute().add(route);
        }
        int[] cnt = new int[3];
        DictionaryReference adultPassengerType = DictHelper.getAdultPassengerType();
        DictionaryReference childPassengerType = DictHelper.getChildPassengerType();
        DictionaryReference infantPassengerType = DictHelper.getInfantPassengerType();
        for (BaseProduct baseProd : reservation.getProducts()) {
            Product prod = (Product)baseProd;
            if (prod.getPassengerType().equals((Object)adultPassengerType)) {
                cnt[0] = cnt[0] + 1;
                continue;
            }
            if (prod.getPassengerType().equals((Object)childPassengerType)) {
                cnt[1] = cnt[1] + 1;
                continue;
            }
            if (!prod.getPassengerType().equals((Object)infantPassengerType)) continue;
            cnt[2] = cnt[2] + 1;
        }
        if (cnt[0] > 0) {
            searchParams.getSeats().add(this.createSeat((DictionaryReference<PassengerType>)adultPassengerType, cnt[0]));
        }
        if (cnt[1] > 0) {
            searchParams.getSeats().add(this.createSeat((DictionaryReference<PassengerType>)childPassengerType, cnt[1]));
        }
        if (cnt[2] > 0) {
            searchParams.getSeats().add(this.createSeat((DictionaryReference<PassengerType>)infantPassengerType, cnt[2]));
        }
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)searchParams);
    }

    private SeatPreferences createSeat(DictionaryReference<PassengerType> type, int cnt) {
        SeatPreferences seat = new SeatPreferences();
        seat.setPassengerType(type);
        seat.setCount(cnt);
        return seat;
    }
}

