/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.ibus.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FindActualFlightForFakeReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List flights = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Flight found = null;
        for (Flight fl : flights) {
            if (!this.equals(reservation, fl)) continue;
            found = fl;
            break;
        }
        if (found == null) {
            throw Xeption.forAdmin((String)"Flight for fake reservation was not found after research", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, found);
    }

    private boolean equals(Reservation r, Flight f) {
        Product p = (Product)r.getProducts().get(0);
        if (p.getSegmentTariffs().size() != f.getSegmentTariffs().size()) {
            return false;
        }
        for (int q = 0; q < p.getSegmentTariffs().size(); ++q) {
            if (this.segmentsTariffEquals((SegmentTariff)p.getSegmentTariffs().get(q), (FlightSegmentTariff)f.getSegmentTariffs().get(q))) continue;
            return false;
        }
        for (BaseProduct bp : r.getProducts()) {
            Product product = (Product)bp;
            ArrayList<FlightFare> fares = new ArrayList<FlightFare>();
            ArrayList<FlightTax> taxes = new ArrayList<FlightTax>();
            for (FlightFare ffare : f.getFares()) {
                if (!ffare.getPassengerType().equals((Object)product.getPassengerType())) continue;
                fares.add(ffare);
            }
            for (FlightTax ftax : f.getTaxes()) {
                if (!ftax.getPassengerType().equals((Object)product.getPassengerType())) continue;
                taxes.add(ftax);
            }
            if (fares.size() != product.getFares().size()) {
                return false;
            }
            for (ProductFare fare : product.getFares()) {
                if (this.containsFare(f.getFares(), fare)) continue;
                return false;
            }
            if (taxes.size() != product.getTaxes().size()) {
                return false;
            }
            for (FlightTax ftax : taxes) {
                if (this.containsTax(ftax, product.getTaxes())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean containsFare(Collection<FlightFare> fares, ProductFare fare) {
        for (FlightFare el : fares) {
            if (el.getBaseAmount().getValue().compareTo(fare.getBaseFare().getValue()) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean containsTax(FlightTax ftax, Collection<Tax> taxes) {
        for (Tax tax : taxes) {
            if (ftax.getBaseAmount().getValue().compareTo(tax.getAmount().getValue()) != 0 || !MiscUtil.equals((Object)ftax.getCode(), (Object)tax.getCode())) continue;
            return true;
        }
        return false;
    }

    private boolean segmentsTariffEquals(SegmentTariff st, FlightSegmentTariff fst) {
        int size = st.getSegments().size();
        if (size != fst.getSegments().size()) {
            return false;
        }
        for (int q = 0; q < size; ++q) {
            Segment seg = (Segment)st.getSegments().get(q);
            FlightSegment fseg = (FlightSegment)fst.getSegments().get(q);
            if (seg.getStartDate().equals(fseg.getDateBegin()) && seg.getEndDate().equals(fseg.getDateEnd()) && seg.getDepartureLocation().equals((Object)fseg.getLocationBegin()) && seg.getArriveLocation().equals((Object)fseg.getLocationEnd())) continue;
            return false;
        }
        return true;
    }
}

