/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.ibus.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.flydubai.FlyDubaiHelper;
import com.gridnine.xtrip.server.gds.flydubai.ibus.FlyDubaiWsMethod;
import com.gridnine.xtrip.server.gds.flydubai.ibus.IBusGdsFlyDubaiContextKeys;
import com.gridnine.xtrip.server.gds.flydubai.ibus.security.FlyDubaiSecurityInfo;
import com.gridnine.xtrip.server.gds.flydubai.mapping.ModelToFlyDubaiConverter;
import com.gridnine.xtrip.server.gds.flydubai.mapping.ReservationBuilderHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsCurrencyCodeTypes;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsPaymentMethodTypes;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsPaymentTransactionStatusTypes;
import org.datacontract.schemas.radixx.connectpoint.fulfillment.ArrayOfProcessPNRPayment;
import org.datacontract.schemas.radixx.connectpoint.fulfillment.PNRPayments;
import org.datacontract.schemas.radixx.connectpoint.reservation.AirlinePerson;
import org.datacontract.schemas.radixx.connectpoint.reservation.ViewPNR;
import org.tempuri.ProcessPNRPayment;

public class ProcessPNRPaymentRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ProcessPNRPayment request = this.buildRequest(ctx);
        ctx.putObject((Enum)IBusGdsFlyDubaiContextKeys.FLYDUBAI_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IBusGdsFlyDubaiContextKeys.FLYDUBAI_WS_REQUEST_METHOD, (Object)FlyDubaiWsMethod.ProcessPNRPayment);
    }

    private ProcessPNRPayment buildRequest(MessageContext ctx) throws Exception {
        FlyDubaiSecurityInfo securityInfo = (FlyDubaiSecurityInfo)ctx.getMandatoryObject((Enum)IBusGdsFlyDubaiContextKeys.SECURITY_INFO);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ViewPNR pnr = (ViewPNR)ctx.getMandatoryObject((Enum)IBusGdsFlyDubaiContextKeys.FLYDUBAI_RESERVATION);
        ProcessPNRPayment request = new ProcessPNRPayment();
        PNRPayments data = new PNRPayments();
        data.setTransactionInfo(ModelToFlyDubaiConverter.createTransactionInfo(securityInfo.getSecurityGuid(), securityInfo.getUserName()));
        data.setReservationInfo(ModelToFlyDubaiConverter.createReservationInfo(FlyDubaiHelper.isFakeReservation(reservation) ? null : FlyDubaiHelper.getRecordLocator(reservation)));
        data.setPNRPayments1(new ArrayOfProcessPNRPayment());
        org.datacontract.schemas.radixx.connectpoint.fulfillment.ProcessPNRPayment payment = new org.datacontract.schemas.radixx.connectpoint.fulfillment.ProcessPNRPayment();
        BigDecimal momBalance = this.calcMomResevationBalance(reservation);
        if (momBalance.compareTo(pnr.getReservationBalance()) < 0) {
            throw Xeption.forAdmin((String)"PNR price more than price of MOM reservation", (Object[])new Object[0]);
        }
        payment.setBaseAmount(pnr.getReservationBalance());
        payment.setBaseCurrency(EnumerationsCurrencyCodeTypes.RUB);
        payment.setOriginalAmount(payment.getBaseAmount());
        payment.setOriginalCurrency(EnumerationsCurrencyCodeTypes.RUB);
        payment.setPaymentAmount(pnr.getReservationBalance());
        payment.setCurrencyPaid(EnumerationsCurrencyCodeTypes.RUB);
        payment.setPaymentMethod(EnumerationsPaymentMethodTypes.INVC);
        payment.setExchangeRate(new BigDecimal(1));
        payment.setExchangeRateDate(new Date());
        payment.setCheckNumber(new BigDecimal(1234));
        payment.setExpirationDate(new Date());
        payment.setDatePaid(new Date());
        payment.setCardHolder("");
        payment.setCardNumber("");
        payment.setCVCode("");
        payment.setDocumentReceivedBy("FZ");
        payment.setFFNumber("11");
        payment.setPaymentComment("");
        payment.setReference("test");
        payment.setUserID(securityInfo.getUserName());
        payment.setUserData("");
        payment.setIataNumber(securityInfo.getIataNumber());
        payment.setValueCode("");
        payment.setGcxID("1");
        payment.setGcxOptOption("1");
        payment.setAuthorizationCode("");
        payment.setPaymentReference("");
        payment.setResponseMessage("");
        payment.setBillingCountry("");
        payment.setFingerPrintingSessionID("");
        payment.setVoucherNumber(Integer.MIN_VALUE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Map<Integer, AirlinePerson> passengers = ReservationBuilderHelper.getPassangers(pnr);
        for (AirlinePerson p : passengers.values()) {
            if (p.getPrimaryPassenger() == null || !p.getPrimaryPassenger().booleanValue()) continue;
            payment.setPayor(ModelToFlyDubaiConverter.createPerson(p, salesContext));
            break;
        }
        payment.setTerminalID(1);
        payment.setTransactionStatus(EnumerationsPaymentTransactionStatusTypes.APPROVED);
        payment.setCardCurrency(EnumerationsCurrencyCodeTypes.RUB);
        data.getPNRPayments1().getProcessPNRPaymentList().add(payment);
        request.setPNRPaymentRequest(data);
        return request;
    }

    private BigDecimal calcMomResevationBalance(Reservation reservation) {
        BigDecimal res = BigDecimal.ZERO;
        for (BaseProduct prod : reservation.getProducts()) {
            if (!(prod instanceof Product)) continue;
            res = res.add(AirProductHelper.getTotalEquivalentFare((Product)((Product)prod)));
        }
        return res;
    }
}

