/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.ibus.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.SimpleCompositeNumber;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.gds.flydubai.FlyDubaiHelper;
import com.gridnine.xtrip.server.gds.flydubai.ibus.IBusGdsFlyDubaiContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.tempuri.ProcessPNRPaymentResponse;

public class ProcessPNRPaymentRSProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ProcessPNRPaymentResponse response = (ProcessPNRPaymentResponse)ctx.getMandatoryObject((Enum)IBusGdsFlyDubaiContextKeys.FLYDUBAI_WS_RESPONSE_PAYLOAD);
        FlyDubaiHelper.checkWsResponse(response.getProcessPNRPaymentResult().getExceptions());
        ctx.putObject((Enum)IBusGdsFlyDubaiContextKeys.FLYDUBAI_WS_RESPONSE_PAYLOAD, null);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        for (BaseProduct bp : reservation.getProducts()) {
            if (!(bp instanceof Product)) continue;
            Product prod = (Product)bp;
            prod.setSystemNumber(ProcessPNRPaymentRSProcessor.buildNextTicketNumber());
        }
    }

    private static String buildNextTicketNumber() throws Exception {
        SimpleCompositeNumber number = new SimpleCompositeNumber();
        String date = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String designator = FlyDubaiHelper.class.getName();
        SequenceNumberHelper.get().generateInc((CompositeNumber)number, designator, null);
        return date + number.getNumber().substring(number.getNumber().length() - 2);
    }
}

