/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.mapping;

import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.flydubai.FlyDubaiHelper;
import com.gridnine.xtrip.server.gds.flydubai.mapping.FlightsBuilderHelper;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.datacontract.schemas.radixx.connectpoint.pricing.ArrayOfFlightSegment;
import org.datacontract.schemas.radixx.connectpoint.pricing.ArrayOfLegDetail;
import org.datacontract.schemas.radixx.connectpoint.pricing.ArrayOfSegmentDetail;
import org.datacontract.schemas.radixx.connectpoint.pricing.ArrayOfTaxDetail;
import org.datacontract.schemas.radixx.connectpoint.pricing.FareInfo;
import org.datacontract.schemas.radixx.connectpoint.pricing.FareType;
import org.datacontract.schemas.radixx.connectpoint.pricing.FlightLegDetail;
import org.datacontract.schemas.radixx.connectpoint.pricing.FlightSegment;
import org.datacontract.schemas.radixx.connectpoint.pricing.LegDetail;
import org.datacontract.schemas.radixx.connectpoint.pricing.SegmentDetail;
import org.datacontract.schemas.radixx.connectpoint.pricing.ViewFareQuote;

public class FlightWrappersBuilder {
    private final Integer flightsLimit;
    private final ViewFareQuote view;
    private final FlightSearchParameters fsp;
    private final GdsTracingItemBuilder<Flight> builder;
    private final boolean isSaveRulesTraces;
    private final boolean allFares;
    private static final int MIN_PERIOD_BETWEEN_SEGMENTS = 30;

    public FlightWrappersBuilder(ViewFareQuote view, FlightSearchParameters fsp, GdsTracingItemBuilder<Flight> builder, boolean isSaveRulesTraces, Integer flightsLimit, boolean allFares) {
        this.view = view;
        this.fsp = fsp;
        this.builder = builder;
        this.isSaveRulesTraces = isSaveRulesTraces;
        this.flightsLimit = flightsLimit;
        this.allFares = allFares;
    }

    public static List<FlightWrapper> buildFlightWrappers(ViewFareQuote view, FlightSearchParameters fsp, GdsTracingItemBuilder<Flight> builder, boolean isSaveRulesTraces, Integer flightsLimit, boolean allFares) throws Exception {
        return new FlightWrappersBuilder(view, fsp, builder, isSaveRulesTraces, flightsLimit, allFares).buildFlightWrappers();
    }

    /*
     * Exception decompiling
     */
    private List<FlightWrapper> buildFlightWrappers() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<List<FlightSegmentWrapper>> equalFareProduct(List<List<FlightSegmentWrapper>> legVariants) {
        ArrayList<List<FlightSegmentWrapper>> listWithFSWLists = new ArrayList<List<FlightSegmentWrapper>>();
        Set<String> listFSW = legVariants.stream().flatMap(Collection::stream).map(seg -> ((FlightSegmentWrapper)seg).bestFareType.getFareTypeName()).collect(Collectors.toSet());
        listFSW.forEach(fareTypeName -> listWithFSWLists.add(legVariants.stream().flatMap(Collection::stream).filter(seg -> MiscUtil.equals((Object)seg.getBestFareType().getFareTypeName(), (Object)fareTypeName)).collect(Collectors.toList())));
        listWithFSWLists.removeIf(e -> e.size() != this.fsp.getRoute().size());
        return listWithFSWLists;
    }

    private static boolean checkData(ViewFareQuote view) {
        ArrayOfFlightSegment segments = view.getFlightSegments();
        ArrayOfLegDetail legDetails = view.getLegDetails();
        ArrayOfSegmentDetail segmentDetails = view.getSegmentDetails();
        ArrayOfTaxDetail taxDetails = view.getTaxDetails();
        return segments != null && !CollectionUtil.isEmpty((Collection)segments.getFlightSegmentList()) && legDetails != null && !CollectionUtil.isEmpty((Collection)legDetails.getLegDetailList()) && segmentDetails != null && !CollectionUtil.isEmpty((Collection)segmentDetails.getSegmentDetailList()) && taxDetails != null && !CollectionUtil.isEmpty((Collection)taxDetails.getTaxDetailList());
    }

    private static String getSegmentTitle(FlightSegment gdsSegment) {
        StringBuilder sb = new StringBuilder();
        sb.append("LFID ").append(gdsSegment.getLFID());
        if (gdsSegment.getDepartureDate() != null) {
            sb.append(" DepartureDate ").append(new SimpleDateFormat("yyyy.MM.dd HH:mm").format(gdsSegment.getDepartureDate()));
        }
        return sb.toString();
    }

    private static String getLegsTitle(List<FlightSegmentWrapper> legs) {
        StringBuilder sb = new StringBuilder();
        legs.forEach(sw -> {
            if (sb.length() != 0) {
                sb.append("-");
            }
            sb.append("(").append(FlightWrappersBuilder.getSegmentTitle(((FlightSegmentWrapper)sw).flightSegment)).append(")");
        });
        return sb.toString();
    }

    private String checkFlightSegment(FlightSegment fdFlightSeg) {
        Date fsDate;
        if (fdFlightSeg.getFlightLegDetails() == null || fdFlightSeg.getFlightLegDetails().getFlightLegDetailList().isEmpty()) {
            return "FlightLegDetails is empty";
        }
        if (fdFlightSeg.getFareTypes() == null || fdFlightSeg.getFareTypes().getFareTypeList().isEmpty()) {
            return "FareTypes is empty";
        }
        FareType fareType = (FareType)fdFlightSeg.getFareTypes().getFareTypeList().get(0);
        if (fareType.getFareInfos() == null || fareType.getFareInfos().getFareInfoList().isEmpty()) {
            return "FareType/FareInfos is empty";
        }
        if (this.fsp.isSkipConnected() && fdFlightSeg.getFlightLegDetails().getFlightLegDetailList().size() > 1) {
            return String.format("skip connected", new Object[0]);
        }
        int index = fdFlightSeg.getLegCount() - 1;
        if (index > this.fsp.getRoute().size()) {
            return String.format("LegCount (%s) exceeded legs size (%s)", index, this.fsp.getRoute().size());
        }
        RouteSegment rs = (RouteSegment)this.fsp.getRoute().get(index);
        Date rsDate = MiscUtil.clearTime((Date)rs.getDate());
        if (!MiscUtil.equals((Object)rsDate, (Object)(fsDate = MiscUtil.clearTime((Date)FlightsBuilderHelper.correctTime(fdFlightSeg.getDepartureDate()))))) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
            return String.format("different dates for %s-%s: %s != %s", rs.getLocationBegin().getCode(), rs.getLocationEnd().getCode(), sdf.format(fsDate), sdf.format(rsDate));
        }
        return null;
    }

    private static boolean validLegs(List<List<FlightSegmentWrapper>> legs) {
        if (legs.isEmpty()) {
            return false;
        }
        for (List<FlightSegmentWrapper> legVariants : legs) {
            if (!legVariants.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static String checkPeriodBetweenSegments(List<FlightSegmentWrapper> legs) {
        FlightSegmentWrapper last = null;
        for (FlightSegmentWrapper sw : legs) {
            String mes;
            if (last != null && !TextUtil.isBlank((String)(mes = FlightWrappersBuilder.checkLegsDates(last.flightSegment, sw.flightSegment)))) {
                return mes;
            }
            last = sw;
        }
        return null;
    }

    private static String checkLegsDates(FlightSegment fs1, FlightSegment fs2) {
        if (MiscUtil.addMinutesToDate((Date)fs1.getArrivalDate(), (int)30).after(fs2.getDepartureDate())) {
            return String.format("between segments (%1$tFT%1$tR - %2$tFT%2$tR) more than %3$s minutes", fs1.getArrivalDate(), fs2.getDepartureDate(), 30);
        }
        return null;
    }

    private static Flight createFakeFlight(FilterFlight ff) {
        Flight result = new Flight();
        FlightSegmentTariff fst = new FlightSegmentTariff();
        com.gridnine.xtrip.common.gds.model.FlightSegment fs = new com.gridnine.xtrip.common.gds.model.FlightSegment();
        fs.setFlightNumber(ff.name());
        fs.setAirline((DictionaryReference)new AirlineReference(""));
        fst.getSegments().add(fs);
        result.getSegmentTariffs().add(fst);
        return result;
    }

    private static boolean checkEqualsTariff(ViewFareQuote viewFareQuote) {
        boolean tariffEquals = true;
        ArrayList<StringBuilder> fareTypeStringList = new ArrayList<StringBuilder>();
        if (!viewFareQuote.getFlightSegments().getFlightSegmentList().isEmpty()) {
            List flightSegmentList = viewFareQuote.getFlightSegments().getFlightSegmentList();
            StringBuilder fareTypeString = new StringBuilder();
            int LFID = ((FlightSegment)flightSegmentList.get(0)).getLFID();
            for (FlightSegment fs : flightSegmentList) {
                if (fs.getLFID() != LFID) {
                    LFID = fs.getLFID();
                    fareTypeStringList.add(fareTypeString);
                    fareTypeString = new StringBuilder();
                }
                fareTypeString.append(((FareType)fs.getFareTypes().getFareTypeList().get(0)).getFareTypeName());
            }
        }
        for (StringBuilder st : fareTypeStringList) {
            if (st.toString().equals(((StringBuilder)fareTypeStringList.get(0)).toString())) continue;
            tariffEquals = false;
        }
        return tariffEquals;
    }

    private static /* synthetic */ void lambda$buildFlightWrappers$0(List legVariants, RouteSegment r) {
        legVariants.add(new ArrayList());
    }

    private static enum FilterFlight {
        INVALID_SEGMENTS,
        INVALID_PERIOD_BETWEEN_SEGMENTS,
        EXCEEDED_LIMIT;

    }

    static class FlightWrapper {
        private final List<FlightSegmentWrapper> legs;

        public FlightWrapper(List<FlightSegmentWrapper> legs) {
            this.legs = legs;
        }

        public List<FlightSegmentWrapper> getLegs() {
            return this.legs;
        }
    }

    static class FlightSegmentWrapper {
        private final FlightSegment flightSegment;
        private final FareType bestFareType;
        private final BigDecimal totalPrice;
        private final SegmentDetail segmentDetail;
        private final List<LegDetail> legDetails;

        public FlightSegmentWrapper(FlightSegment flightSegment, ViewFareQuote view, FlightSearchParameters fsp) {
            this.flightSegment = flightSegment;
            this.bestFareType = this.getBestFareType(flightSegment.getFareTypes().getFareTypeList(), fsp);
            this.totalPrice = this.getTotal(this.bestFareType);
            this.segmentDetail = this.getSegmentDetail(flightSegment, view);
            this.legDetails = this.getLegDetails(flightSegment, view);
        }

        private FareType getBestFareType(List<FareType> fareTypes, FlightSearchParameters fsp) {
            FareType anyResult = fareTypes.get(0);
            FareType serviceClassResult = null;
            BigDecimal bestPrice = new BigDecimal(Integer.MAX_VALUE);
            BigDecimal bestServiceClassPrice = new BigDecimal(Integer.MAX_VALUE);
            for (FareType fareType : fareTypes) {
                BigDecimal total = this.getTotal(fareType);
                if (total.compareTo(bestPrice) < 0) {
                    bestPrice = total;
                    anyResult = fareType;
                }
                ClassOfService serviceClass = FlyDubaiHelper.convertClassOfServiceFromGds((FareInfo)fareType.getFareInfos().getFareInfoList().get(0));
                if (fsp == null || serviceClass != fsp.getServiceClass() || total.compareTo(bestServiceClassPrice) >= 0) continue;
                bestServiceClassPrice = total;
                serviceClassResult = fareType;
            }
            return serviceClassResult != null ? serviceClassResult : anyResult;
        }

        private BigDecimal getTotal(FareType fareType) {
            BigDecimal result = new BigDecimal(0);
            for (FareInfo fareInfo : fareType.getFareInfos().getFareInfoList()) {
                result = result.add(fareInfo.getBaseFareAmt());
            }
            return result;
        }

        private SegmentDetail getSegmentDetail(FlightSegment flightSegment, ViewFareQuote view) {
            for (SegmentDetail detail : view.getSegmentDetails().getSegmentDetailList()) {
                if (detail.getLFID() != flightSegment.getLFID()) continue;
                return detail;
            }
            return null;
        }

        private List<LegDetail> getLegDetails(FlightSegment flightSegment, ViewFareQuote view) {
            ArrayList<LegDetail> result = new ArrayList<LegDetail>();
            for (FlightLegDetail fdLeg : flightSegment.getFlightLegDetails().getFlightLegDetailList()) {
                result.add(FlightSegmentWrapper.findLegDetail(fdLeg, view.getLegDetails().getLegDetailList()));
            }
            return result;
        }

        private static LegDetail findLegDetail(FlightLegDetail fdLeg, List<LegDetail> legDetails) {
            for (LegDetail leg : legDetails) {
                if (leg.getPFID() != fdLeg.getPFID() || !leg.getDepartureDate().equals(fdLeg.getDepartureDate())) continue;
                return leg;
            }
            return null;
        }

        public FlightSegment getFlightSegment() {
            return this.flightSegment;
        }

        public FareType getBestFareType() {
            return this.bestFareType;
        }

        public BigDecimal getTotalPrice() {
            return this.totalPrice;
        }

        public SegmentDetail getSegmentDetail() {
            return this.segmentDetail;
        }

        public List<LegDetail> getLegDetails() {
            return this.legDetails;
        }
    }

    static class FlightSegmentsComparator
    implements Comparator<List<FlightSegmentWrapper>> {
        FlightSegmentsComparator() {
        }

        @Override
        public int compare(List<FlightSegmentWrapper> fl1, List<FlightSegmentWrapper> fl2) {
            BigDecimal pr1 = FlightSegmentsComparator.calcLegPrice(fl1);
            BigDecimal pr2 = FlightSegmentsComparator.calcLegPrice(fl2);
            int result = MiscUtil.compare((Comparable)pr1, (Comparable)pr2);
            return result;
        }

        private static BigDecimal calcLegPrice(List<FlightSegmentWrapper> segmentWrappers) {
            BigDecimal result = BigDecimal.ZERO;
            for (FlightSegmentWrapper sw : segmentWrappers) {
                result = result.add(sw.totalPrice);
            }
            return result;
        }

        public static String buildFlightNumbersString(List<FlightSegmentWrapper> segments) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            StringBuilder sb = new StringBuilder();
            segments.stream().forEach(fs -> {
                SegmentDetail segmentDetail = ((FlightSegmentWrapper)fs).segmentDetail;
                ((FlightSegmentWrapper)fs).legDetails.forEach(ld -> {
                    if (sb.length() > 0) {
                        sb.append('|');
                    }
                    sb.append(segmentDetail.getOperatingCarrier().trim());
                    sb.append(segmentDetail.getFlightNum());
                    sb.append('/');
                    sb.append(df.format(ld.getDepartureDate()));
                });
            });
            return sb.toString();
        }
    }
}

