/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.mapping;

import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rpc.logging.ServiceInvocationLoggingHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.flydubai.FlyDubaiHelper;
import com.gridnine.xtrip.server.gds.flydubai.ibus.FlyDubaiSearchParams;
import com.gridnine.xtrip.server.gds.flydubai.mapping.FlightWrappersBuilder;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.datacontract.schemas.radixx.connectpoint.pricing.ApplicableTaxDetail;
import org.datacontract.schemas.radixx.connectpoint.pricing.ArrayOfTaxDetail;
import org.datacontract.schemas.radixx.connectpoint.pricing.FareInfo;
import org.datacontract.schemas.radixx.connectpoint.pricing.FareType;
import org.datacontract.schemas.radixx.connectpoint.pricing.LegDetail;
import org.datacontract.schemas.radixx.connectpoint.pricing.SegmentDetail;
import org.datacontract.schemas.radixx.connectpoint.pricing.TaxDetail;
import org.datacontract.schemas.radixx.connectpoint.pricing.ViewFareQuote;

public class FlightsBuilderHelper {
    private static final String PROP_FARE_TYPE_NAME = "fareTypeName";
    private static final String PROP_FARE_TYPE_ID = "fareTypeId";

    public static List<Flight> createFlights(ViewFareQuote view, FlightSearchParameters fsp, GDSParameters gdsParams) throws Exception {
        return FlightsBuilderHelper.createFlights(view, fsp, gdsParams, null, false, null, false);
    }

    public static List<Flight> createFlights(ViewFareQuote view, FlightSearchParameters fsp, GDSParameters gdsParams, GdsTracingItemBuilder<Flight> builder, boolean isSaveRulesTraces, Integer flightsLimit, boolean allFares) throws Exception {
        FlightsBuilderHelper.enrichStackTrace(fsp);
        List<FlightWrappersBuilder.FlightWrapper> flightWrappers = FlightWrappersBuilder.buildFlightWrappers(view, fsp, builder, isSaveRulesTraces, flightsLimit, allFares);
        ArrayList<Flight> flights = new ArrayList<Flight>();
        for (FlightWrappersBuilder.FlightWrapper flightWrapper : flightWrappers) {
            flights.add(FlightsBuilderHelper.buildFlight(flightWrapper, view, fsp, gdsParams));
        }
        if (fsp != null) {
            for (Flight flight : flights) {
                flight.getSeats().addAll(fsp.getSeats());
            }
        }
        return flights;
    }

    private static void enrichStackTrace(FlightSearchParameters fsp) {
        String newStackTrace;
        String clientStacktrace = ServiceInvocationLoggingHelper.getThreadLocalClientStacktrace();
        StringBuilder sb = new StringBuilder();
        if (TextUtil.nonBlank((String)clientStacktrace)) {
            sb.append(clientStacktrace).append("\n");
        }
        if (fsp != null) {
            sb.append(GDSHelper.buildRouteInfo((FlightSearchParameters)fsp));
        }
        if (TextUtil.nonBlank((String)(newStackTrace = sb.toString()))) {
            ServiceInvocationLoggingHelper.setThreadLocalClientStacktrace((String)newStackTrace);
        }
    }

    private static Flight buildFlight(FlightWrappersBuilder.FlightWrapper flightWrapper, ViewFareQuote view, FlightSearchParameters fsp, GDSParameters gdsParams) throws Exception {
        DictionaryReference adultRef = DictHelper.getAdultPassengerType();
        Flight result = new Flight();
        result.setEticket(true);
        result.setGds(GdsName.FLY_DUBAI);
        result.setLatinRegistration(true);
        result.setCarrier(FlyDubaiHelper.resolveNativeCode(Airline.class, "FZ"));
        result.setAccountCode("");
        String gdsCurrencyCode = view.getRequestedCurrencyOfFareQuote();
        result.setGdsCurrencyCode(gdsCurrencyCode);
        if (gdsParams != null) {
            result.setBlankOwner(gdsParams.getBlankOwner());
        }
        int index = 0;
        for (FlightWrappersBuilder.FlightSegmentWrapper leg : flightWrapper.getLegs()) {
            FlightSegmentTariff segmentTariff = FlightsBuilderHelper.buildSegmentTariff(leg, view);
            result.getSegmentTariffs().add(segmentTariff);
            for (FareInfo fdFareInfo : leg.getBestFareType().getFareInfos().getFareInfoList()) {
                FlightFare fare = FlightsBuilderHelper.createFlightFare(segmentTariff, fdFareInfo, gdsCurrencyCode);
                if (adultRef.equals((Object)fare.getPassengerType())) {
                    segmentTariff.getCustomProperties().add(NamedValueHelper.namedValue((String)"fareId", (String)String.valueOf(fdFareInfo.getFareID())));
                }
                List<FlightTax> taxes = FlightsBuilderHelper.createFlightTaxes(segmentTariff, fdFareInfo, view.getTaxDetails(), gdsCurrencyCode);
                result.getTaxes().addAll(taxes);
                result.getFares().add(fare);
            }
            FlyDubaiSearchParams fdParams = null;
            if (fsp != null) {
                fdParams = new FlyDubaiSearchParams((DictionaryReference<GeoLocation>)((RouteSegment)fsp.getRoute().get(index)).getLocationBegin(), (DictionaryReference<GeoLocation>)((RouteSegment)fsp.getRoute().get(index)).getLocationEnd());
            }
            ++index;
            segmentTariff.getCustomProperties().add(NamedValueHelper.namedValue((String)"searchParams", (String)(fdParams != null ? fdParams.convertToString() : null)));
        }
        return result;
    }

    private static FlightSegmentTariff buildSegmentTariff(FlightWrappersBuilder.FlightSegmentWrapper flightSegmentWrapper, ViewFareQuote view) throws Exception {
        FareType fareType = flightSegmentWrapper.getBestFareType();
        FlightSegmentTariff result = new FlightSegmentTariff();
        result.setGds(GdsName.FLY_DUBAI);
        List<FlightSegment> segments = FlightsBuilderHelper.createFlightSegments(flightSegmentWrapper.getSegmentDetail(), flightSegmentWrapper.getLegDetails(), fareType, view.getTaxDetails());
        result.getCustomProperties().add(NamedValueHelper.namedValue((String)PROP_FARE_TYPE_NAME, (String)fareType.getFareTypeName()));
        result.getCustomProperties().add(NamedValueHelper.namedValue((String)PROP_FARE_TYPE_ID, (String)String.valueOf(fareType.getFareTypeID())));
        result.getSegments().addAll(segments);
        return result;
    }

    private static List<FlightSegment> createFlightSegments(SegmentDetail fdSegmentDetail, List<LegDetail> legDetails, FareType fareType, ArrayOfTaxDetail taxDetails) throws Exception {
        ArrayList<FlightSegment> result = new ArrayList<FlightSegment>();
        FareInfo adultFareInfo = null;
        for (FareInfo info : fareType.getFareInfos().getFareInfoList()) {
            if (info.getPTCID() != 1) continue;
            adultFareInfo = info;
            break;
        }
        if (adultFareInfo == null) {
            throw new IllegalArgumentException("No FareInfo for adult!");
        }
        for (LegDetail fdLeg : legDetails) {
            FlightSegment segment = new FlightSegment();
            segment.setGds(GdsName.FLY_DUBAI);
            segment.setServiceClass(FlyDubaiHelper.convertClassOfServiceFromGds(adultFareInfo));
            segment.setBookingClass(StringUtils.trim((String)adultFareInfo.getFCCode()));
            segment.setBoard(FlyDubaiHelper.resolveNativeCode(Aircraft.class, fdSegmentDetail.getAircraftType().trim()));
            segment.setAirline(FlyDubaiHelper.resolveNativeCode(Airline.class, fdLeg.getOperatingCarrier().trim()));
            segment.setOperatingAirline(segment.getAirline());
            segment.setFlightNumber(fdLeg.getFlightNum());
            segment.setLocationBegin(FlyDubaiHelper.resolveNativeCode(GeoLocation.class, fdLeg.getOrigin().trim()));
            segment.setLocationEnd(FlyDubaiHelper.resolveNativeCode(GeoLocation.class, fdLeg.getDestination().trim()));
            segment.setDateBegin(FlightsBuilderHelper.correctTime(fdLeg.getDepartureDate()));
            segment.setDateEnd(FlightsBuilderHelper.correctTime(fdLeg.getArrivalDate()));
            segment.setTravelDuration((int)Math.round(fdLeg.getFlightTime()));
            int minSeatsAvailable = Integer.MAX_VALUE;
            for (FareInfo info : fareType.getFareInfos().getFareInfoList()) {
                if (info.getSeatsAvailable() >= minSeatsAvailable) continue;
                minSeatsAvailable = info.getSeatsAvailable();
            }
            segment.setAvailableSeats(Integer.valueOf(minSeatsAvailable));
            if (result.size() == 0) {
                segment.setStarting(true);
            }
            segment.setGdsId(String.valueOf(fdLeg.getPFID()));
            for (FareInfo info : fareType.getFareInfos().getFareInfoList()) {
                com.gridnine.xtrip.common.gds.model.FareInfo finfo = new com.gridnine.xtrip.common.gds.model.FareInfo();
                finfo.setPassengerType(FlyDubaiHelper.convertIntToPassengerType(info.getPTCID()));
                finfo.setRemarksSearchContext(String.valueOf(fareType.getFareTypeID()));
                finfo.setFareBasis(info.getFBCode());
                if (info.getApplicableTaxDetails() != null && info.getApplicableTaxDetails().getApplicableTaxDetailList() != null) {
                    for (ApplicableTaxDetail appTax : info.getApplicableTaxDetails().getApplicableTaxDetailList()) {
                        for (TaxDetail taxDetail : taxDetails.getTaxDetailList()) {
                            String taxDesc;
                            if (taxDetail.getTaxID() != appTax.getTaxID() || !FlyDubaiHelper.isBaggageTaxCode(taxDetail.getTaxCode()) || TextUtil.isBlank((String)(taxDesc = taxDetail.getTaxDesc()))) continue;
                            finfo.setLuggageInfo(AirProductHelper.parseLuggageInfo((String)taxDesc.substring(0, taxDesc.indexOf(" "))));
                        }
                    }
                }
                if (finfo.getLuggageInfo() == null) {
                    finfo.setLuggageInfo(AirProductHelper.buildNilLuggageInfo());
                }
                segment.getFareInfos().add(finfo);
            }
            result.add(segment);
        }
        return result;
    }

    public static Date correctTime(Date dt) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(dt);
        Calendar newCal = Calendar.getInstance();
        newCal.set(cal.get(1), cal.get(2), cal.get(5), cal.get(11), cal.get(12), cal.get(13));
        newCal.set(14, 0);
        return newCal.getTime();
    }

    private static FlightFare createFlightFare(FlightSegmentTariff st, FareInfo fareInfo, String gdsCurrencyCode) throws Exception {
        FlightFare fare = new FlightFare();
        fare.setPassengerType(FlyDubaiHelper.convertIntToPassengerType(fareInfo.getPTCID()));
        fare.setSegmentTariff(st);
        Money amount = new Money();
        amount.setValue(FlyDubaiHelper.round(fareInfo.getBaseFareAmtNoTaxes()));
        amount.setCurrency(gdsCurrencyCode);
        fare.setBaseAmount(amount);
        fare.setEquivalentAmount(amount.getValue());
        NamedValueHelper.setValueForName((String)"flydubai-fare-code", (String)StringUtils.trim((String)fareInfo.getFCCode()), (Collection)fare.getCustomProperties());
        return fare;
    }

    private static List<FlightTax> createFlightTaxes(FlightSegmentTariff st, FareInfo fareInfo, ArrayOfTaxDetail taxDetails, String gdsCurrencyCode) throws Exception {
        ArrayList<FlightTax> taxes = new ArrayList<FlightTax>();
        if (fareInfo.getApplicableTaxDetails() == null || fareInfo.getApplicableTaxDetails().getApplicableTaxDetailList() == null) {
            return taxes;
        }
        for (ApplicableTaxDetail appTax : fareInfo.getApplicableTaxDetails().getApplicableTaxDetailList()) {
            FlightTax tax = new FlightTax();
            tax.setPassengerType(FlyDubaiHelper.convertIntToPassengerType(fareInfo.getPTCID()));
            tax.setSegmentTariff(st);
            Money amount = new Money();
            amount.setValue(appTax.getAmt());
            amount.setCurrency(gdsCurrencyCode);
            tax.setBaseAmount(amount);
            tax.setEquivalentAmount(amount.getValue());
            for (TaxDetail taxDetail : taxDetails.getTaxDetailList()) {
                if (taxDetail.getTaxID() != appTax.getTaxID()) continue;
                tax.setCode(taxDetail.getTaxCode());
            }
            taxes.add(tax);
        }
        return taxes;
    }
}

