/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.mapping;

import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.helpers.CommunicationFormat;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.flydubai.FlyDubaiHelper;
import com.gridnine.xtrip.server.gds.flydubai.TravelAgentData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.datacontract.schemas.radixx.connectpoint.ArrayOfCarrierCode;
import org.datacontract.schemas.radixx.connectpoint.CarrierCode;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsContactTypes;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsCurrencyCodeTypes;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsGenderTypes;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsPaymentMethodTypes;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsRelationshipTypes;
import org.datacontract.schemas.radixx.connectpoint.ReservationInfo;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;
import org.datacontract.schemas.radixx.connectpoint.reservation.Address;
import org.datacontract.schemas.radixx.connectpoint.reservation.AirlinePerson;
import org.datacontract.schemas.radixx.connectpoint.reservation.ArrayOfContactInfo;
import org.datacontract.schemas.radixx.connectpoint.reservation.ArrayOfPerson;
import org.datacontract.schemas.radixx.connectpoint.reservation.ArrayOfSeat;
import org.datacontract.schemas.radixx.connectpoint.reservation.ArrayOfSegment;
import org.datacontract.schemas.radixx.connectpoint.reservation.ArrayOfSpecialService;
import org.datacontract.schemas.radixx.connectpoint.reservation.ContactInfo;
import org.datacontract.schemas.radixx.connectpoint.reservation.Payment;
import org.datacontract.schemas.radixx.connectpoint.reservation.Person;
import org.datacontract.schemas.radixx.connectpoint.reservation.Segment;

public class ModelToFlyDubaiConverter {
    private static final String PNR_SERIES_NUMBER = "299";

    public static ReservationInfo createReservationInfo(String confNumber) {
        ReservationInfo info = new ReservationInfo();
        info.setSeriesNumber(PNR_SERIES_NUMBER);
        info.setConfirmationNumber(StringUtils.isEmpty((String)confNumber) ? "" : confNumber);
        return info;
    }

    public static TransactionInfo createTransactionInfo(String securityGuid, String userName) {
        TransactionInfo info = new TransactionInfo();
        info.setCarrierCodes(ModelToFlyDubaiConverter.buildCarrierCodes());
        info.setSecurityGUID(securityGuid);
        info.setHistoricUserName(userName);
        info.setClientIPAddress("");
        return info;
    }

    public static Person createPerson(AirlinePerson ap, SalesContext salesCtx) throws Exception {
        Person p = new Person();
        p.setAddress(ModelToFlyDubaiConverter.createAddress(salesCtx));
        p.setFirstName(ap.getFirstName());
        p.setLastName(ap.getLastName());
        p.setMiddleName(ap.getMiddleName());
        p.setDOB(ap.getDOB());
        p.setTitle(ap.getTitle());
        p.setRedressNumber("");
        p.setKnownTravelerNumber("");
        p.setCompany("");
        p.setComments("");
        p.setPassport(ap.getPassport());
        p.setGender(EnumerationsGenderTypes.MALE);
        p.setRelationType(EnumerationsRelationshipTypes.SELF);
        p.setPTC(String.valueOf(ap.getPTCID()));
        p.setPTCID(ap.getPTCID().intValue());
        p.setWBCID(ap.getPTCID().intValue());
        p.setNationality("");
        p.setContactInfos(new ArrayOfContactInfo());
        p.setPersonOrgID(ap.getPersonOrgID());
        p.setTravelsWithPersonOrgID(ap.getPersonOrgID());
        return p;
    }

    public static Address createAddress(SalesContext salesCtx) throws Exception {
        TravelAgentData data = FlyDubaiHelper.buildTravelAgentData(salesCtx);
        Address addr = new Address();
        addr.setAddress1(data.getTravelAgentAddress1() != null ? data.getTravelAgentAddress1() : "");
        addr.setAddress2(data.getTravelAgentAddress2() != null ? data.getTravelAgentAddress2() : "");
        addr.setAreaCode("");
        addr.setCity(data.getTravelAgentCity() != null ? data.getTravelAgentCity() : "");
        addr.setCountry(data.getTravelAgentCountry() != null ? data.getTravelAgentCountry() : "");
        addr.setCountryCode("");
        addr.setDisplay("");
        addr.setPhoneNumber("");
        addr.setPostal("");
        addr.setState(data.getTravelAgentState() != null ? data.getTravelAgentState() : "");
        return addr;
    }

    public static ArrayOfCarrierCode buildCarrierCodes() {
        ArrayOfCarrierCode codes = new ArrayOfCarrierCode();
        codes.setCarrierCodeList(new ArrayList());
        CarrierCode code = new CarrierCode();
        code.setAccessibleCarrierCode("FZ");
        codes.getCarrierCodeList().add(code);
        return codes;
    }

    public static ContactInfo createContactInfo(Communication comm, int personOrgId, int contactId, boolean preferredContact) {
        ContactInfo info = new ContactInfo();
        info.setContactType(ModelToFlyDubaiConverter.convertContactType(comm.getType()));
        info.setCountryCode(comm.getCountryCode() != null ? ProfileHelper.normalizeCommunicationPart((String)comm.getCountryCode()) : "");
        info.setAreaCode(comm.getCityCode() != null ? ProfileHelper.normalizeCommunicationPart((String)comm.getCityCode()) : "");
        info.setExtension("");
        CommunicationFormat format = new CommunicationFormat("CTN");
        if (comm.getType() == CommunicationType.HOME_PHONE || comm.getType() == CommunicationType.MOBILE || comm.getType() == CommunicationType.WORK_PHONE) {
            String phone = format.format(comm);
            if (phone.length() > 12) {
                phone = phone.substring(0, 12);
            }
            info.setPhoneNumber(phone);
            info.setContactField(info.getPhoneNumber());
        } else {
            info.setPhoneNumber("");
            info.setContactField(ProfileHelper.normalizeCommunicationPart((String)comm.getSense()));
        }
        info.setDisplay("");
        info.setContactID(contactId);
        info.setPersonOrgID(personOrgId);
        info.setPreferredContactMethod(preferredContact);
        return info;
    }

    private static EnumerationsContactTypes convertContactType(CommunicationType commType) {
        if (commType == null) {
            return null;
        }
        if (commType.equals((Object)CommunicationType.EMAIL)) {
            return EnumerationsContactTypes.EMAIL;
        }
        if (commType.equals((Object)CommunicationType.HOME_PHONE)) {
            return EnumerationsContactTypes.HOME_PHONE;
        }
        if (commType.equals((Object)CommunicationType.WORK_PHONE)) {
            return EnumerationsContactTypes.WORK_PHONE;
        }
        if (commType.equals((Object)CommunicationType.FAX)) {
            return EnumerationsContactTypes.FAX;
        }
        if (commType.equals((Object)CommunicationType.MOBILE)) {
            return EnumerationsContactTypes.MOBILE_PHONE;
        }
        return null;
    }

    public static Payment createDefPayment() {
        Payment payment = new Payment();
        payment.setCompanyName("VIP Service");
        payment.setFirstName("VIP Service");
        payment.setLastName("VIP Service");
        payment.setCardType("");
        payment.setCardNum("");
        payment.setCardHolder("");
        payment.setPaymentCurrency(EnumerationsCurrencyCodeTypes.RUB);
        payment.setISOCurrency(1);
        payment.setPaymentAmount(new BigDecimal(0));
        payment.setPaymentMethod(EnumerationsPaymentMethodTypes.INVC);
        payment.setCardNum("");
        payment.setCVCode("");
        payment.setExpirationDate(FlyDubaiHelper.getDateWithoutTimezone(new Date()));
        payment.setGcxID("1");
        payment.setGcxOpt("1");
        payment.setOriginalCurrency("RUB");
        payment.setOriginalAmount(new BigDecimal(0));
        payment.setExchangeRate(new BigDecimal(1));
        payment.setExchangeRateDate(FlyDubaiHelper.getDateWithoutTimezone(new Date()));
        payment.setPaymentComment("");
        payment.setReservationPaymentID(Integer.MIN_VALUE);
        payment.setBillingCountry("");
        payment.setVoucherNum(Integer.MIN_VALUE);
        return payment;
    }

    public static ArrayOfPerson createPassengers(List<GdsTraveller> gdsTravellers, Collection<Traveller> travellers, SalesContext salesCtx) throws Exception {
        ArrayOfPerson passengers = new ArrayOfPerson();
        int id = -215;
        boolean primaryAdded = false;
        ArrayList<Integer> adultOrgIDs = new ArrayList<Integer>();
        int adultPTCID = FlyDubaiHelper.convertPassengerTypeToInt((DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType());
        for (GdsTraveller gdsTraveller : gdsTravellers) {
            Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)gdsTraveller.getTravellerUid());
            Person p = ModelToFlyDubaiConverter.createPerson(traveller, id, (DictionaryReference<PassengerType>)gdsTraveller.getPassengerType(), salesCtx);
            if (p.getPTCID() == adultPTCID) {
                adultOrgIDs.add(p.getPersonOrgID());
            }
            if (!primaryAdded && p.getPTCID() == adultPTCID) {
                p.setIsPrimaryPassenger(true);
                primaryAdded = true;
            }
            passengers.getPersonList().add(p);
            --id;
        }
        if (adultOrgIDs.isEmpty()) {
            throw new IllegalStateException("No adult in request!");
        }
        int adultOrgIDIdx = 0;
        int childPTCID = FlyDubaiHelper.convertPassengerTypeToInt((DictionaryReference<PassengerType>)DictHelper.getInfantPassengerType());
        for (Person p : passengers.getPersonList()) {
            if (p.getPTCID() == childPTCID) {
                p.setTravelsWithPersonOrgID(((Integer)adultOrgIDs.get(adultOrgIDIdx++)).intValue());
                continue;
            }
            p.setTravelsWithPersonOrgID(((Integer)adultOrgIDs.get(0)).intValue());
        }
        return passengers;
    }

    private static Person createPerson(Traveller traveller, int personOrgId, DictionaryReference<PassengerType> type, SalesContext salesCtx) throws Exception {
        Passport passport = traveller.getPassport();
        Person p = new Person();
        p.setPersonOrgID(personOrgId);
        p.setFirstName(passport.getFirstName());
        p.setLastName(passport.getLastName());
        p.setMiddleName(passport.getMiddleName() != null ? passport.getMiddleName() : "");
        if (passport.getBirthday() != null) {
            p.setAge(FlyDubaiHelper.calcAge(passport.getBirthday()));
            p.setDOB(passport.getBirthday());
        }
        p.setGender(ModelToFlyDubaiConverter.createGender(passport.getGender()));
        if (DictHelper.isEqualsPredifinedValue(type, (DictPredifinedValueProvider[])new DictPredifinedValueProvider[]{PassengerTypeValue.ADULT, PassengerTypeValue.CHILD, PassengerTypeValue.INFANT})) {
            p.setPTCID(FlyDubaiHelper.convertPassengerTypeToInt(type));
        } else {
            p.setPTCID(FlyDubaiHelper.getPassengerTypeInt(passport.getBirthday()));
        }
        if (type == DictHelper.getAdultPassengerType()) {
            p.setTitle(p.getGender().equals((Object)EnumerationsGenderTypes.FEMALE) ? "MS" : "MR");
        } else {
            p.setTitle(p.getGender().equals((Object)EnumerationsGenderTypes.FEMALE) ? "MISS" : "MSTR");
        }
        p.setRelationType(EnumerationsRelationshipTypes.SELF);
        p.setWBCID(p.getPTCID());
        p.setPTC(String.valueOf(p.getPTCID()));
        p.setRedressNumber("na");
        p.setKnownTravelerNumber("na");
        p.setMarketingOptIn(true);
        p.setUseInventory(false);
        p.setAddress(ModelToFlyDubaiConverter.createAddress(salesCtx));
        p.setCompany("");
        p.setComments("");
        p.setPassport(passport.getNumber());
        p.setNationality(FlyDubaiHelper.getNativeCode(passport.getCitizenship()));
        p.setProfileId(Integer.MIN_VALUE);
        p.setContactInfos(ModelToFlyDubaiConverter.createAgentContactInfos(personOrgId, salesCtx, traveller));
        return p;
    }

    public static ArrayOfContactInfo createAgentContactInfos(int personOrgId, SalesContext salesCtx, Traveller traveller) throws Exception {
        ArrayList<Communication> comms = new ArrayList<Communication>();
        TravelAgentData data = FlyDubaiHelper.buildTravelAgentData(salesCtx);
        Communication travellerPhone = null;
        for (Communication comm : ProfileHelper.getPhoneCommunications((List)traveller.getCommunications())) {
            if (comm == null) continue;
            travellerPhone = comm;
            break;
        }
        if (travellerPhone != null) {
            comms.add(travellerPhone);
        }
        comms.add(data.getTravelAgentEmail());
        return ModelToFlyDubaiConverter.createContactInfos(comms, personOrgId);
    }

    public static ArrayOfContactInfo createAgentContactInfos(int personOrgId, SalesContext salesCtx) throws Exception {
        ArrayList<Communication> comms = new ArrayList<Communication>();
        TravelAgentData data = FlyDubaiHelper.buildTravelAgentData(salesCtx);
        if (data.getTravelAgentMobilePhone() == null) {
            throw Xeption.forAdmin((String)Messages.MobilePhoneIsEmptyBothInAgentProfileAndAgentMainEmploymentProfile, (Object[])new Object[0]);
        }
        comms.add(data.getTravelAgentMobilePhone());
        if (data.getTravelAgentHomePhone() == null) {
            throw Xeption.forAdmin((String)Messages.HomePhoneIsEmptyBothInAgentProfileAndAgentMainEmploymentProfile, (Object[])new Object[0]);
        }
        comms.add(data.getTravelAgentHomePhone());
        if (data.getTravelAgentEmail() == null) {
            throw Xeption.forAdmin((String)Messages.EmailIsEmptyBothInAgentProfileAndAgentMainEmploymentProfile, (Object[])new Object[0]);
        }
        comms.add(data.getTravelAgentEmail());
        return ModelToFlyDubaiConverter.createContactInfos(comms, personOrgId);
    }

    public static ArrayOfContactInfo createContactInfos(List<Communication> communications, int personOrgId) {
        int contactId = personOrgId * 10;
        boolean preferredContact = true;
        ArrayOfContactInfo infos = new ArrayOfContactInfo();
        for (Communication comm : communications) {
            infos.getContactInfoList().add(ModelToFlyDubaiConverter.createContactInfo(comm, personOrgId, --contactId, preferredContact));
            preferredContact = false;
        }
        return infos;
    }

    public static ArrayOfSegment createSegments(ArrayOfPerson persons, List<FlightSegmentTariff> segmentTariffs, int primaryPersonOrgId) {
        ArrayOfSegment segments = new ArrayOfSegment();
        for (FlightSegmentTariff segTariff : segmentTariffs) {
            Segment segment = new Segment();
            segment.setPersonOrgID(primaryPersonOrgId);
            String fareid = NamedValueHelper.getValueForName((String)"fareId", (Collection)segTariff.getCustomProperties());
            segment.setFareInformationID(Integer.parseInt(fareid));
            segment.setMarketingCode("");
            segment.setStoreFrontID("");
            segment.setSpecialServices(new ArrayOfSpecialService());
            segment.setSeats(new ArrayOfSeat());
            segments.getSegmentList().add(segment);
        }
        return segments;
    }

    private static EnumerationsGenderTypes createGender(Gender gender) {
        if (gender == null) {
            return EnumerationsGenderTypes.UNKNOWN;
        }
        switch (gender) {
            case MALE: {
                return EnumerationsGenderTypes.MALE;
            }
            case FEMALE: {
                return EnumerationsGenderTypes.FEMALE;
            }
        }
        return EnumerationsGenderTypes.UNKNOWN;
    }
}

