/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.flydubai.mapping;

import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.flydubai.FlyDubaiHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datacontract.schemas.radixx.connectpoint.reservation.AirlinePerson;
import org.datacontract.schemas.radixx.connectpoint.reservation.ArrayOfLogicalFlight;
import org.datacontract.schemas.radixx.connectpoint.reservation.Charge;
import org.datacontract.schemas.radixx.connectpoint.reservation.Customer;
import org.datacontract.schemas.radixx.connectpoint.reservation.LogicalFlight;
import org.datacontract.schemas.radixx.connectpoint.reservation.PhysicalFlight;
import org.datacontract.schemas.radixx.connectpoint.reservation.ViewPNR;

public class ReservationBuilderHelper {
    private static final String CHARGE_TYPE_AIR = "AIR";

    public static Reservation createReservation(ViewPNR viewPnr, BigDecimal tfee, Flight flight, Collection<Traveller> travellers) throws Exception {
        Reservation res = new Reservation();
        res.setResDate(new Date());
        res.setPricingDate(new Date());
        res.setRefreshFromGdsDate(new Date());
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)res, (GdsName)GdsName.FLY_DUBAI, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)viewPnr.getConfirmationNumber());
        res.setRefreshFromGdsDate(new Date());
        String reservationCurrency = viewPnr.getReservationCurrency().name();
        Map<Integer, AirlinePerson> persons = ReservationBuilderHelper.getPassangers(viewPnr);
        for (AirlinePerson person : persons.values()) {
            Product prod = new Product();
            prod.setGdsId(person.getKey());
            prod.setGdsCurrency(reservationCurrency);
            prod.setCarrier(FlyDubaiHelper.resolveNativeCode(Airline.class, "FZ"));
            prod.setPassengerType(FlyDubaiHelper.convertIntToPassengerType(person.getPTCID()));
            prod.setProductCategory(ProductCategory.AIR);
            prod.setTariffType(TariffType.REGULAR);
            ArrayOfLogicalFlight logicalFlights = ((org.datacontract.schemas.radixx.connectpoint.reservation.Airline)viewPnr.getAirlines().getAirlineList().get(0)).getLogicalFlight();
            List logFlights = logicalFlights.getLogicalFlightList();
            Collections.sort(logFlights, new Comparator<LogicalFlight>(){

                @Override
                public int compare(LogicalFlight o1, LogicalFlight o2) {
                    return o1.getDepartureTime().compareTo(o2.getDepartureTime());
                }
            });
            for (LogicalFlight lFlight : logicalFlights.getLogicalFlightList()) {
                List<Charge> charges = ReservationBuilderHelper.getCharges(lFlight, person);
                SegmentTariff st = ReservationBuilderHelper.createSegmentTariff(lFlight, person, flight, charges);
                prod.getSegmentTariffs().add(st);
                for (Charge charge : charges) {
                    if (CHARGE_TYPE_AIR.equals(charge.getCodeType().trim())) {
                        ProductFare prodFare = new ProductFare();
                        prodFare.setBaseFare(ReservationBuilderHelper.getOriginalChargeAmount(charge));
                        prodFare.setSegmentTariff(st);
                        prodFare.setEquivalentFare(charge.getAmount());
                        prod.getFares().add(prodFare);
                        continue;
                    }
                    Tax tax = new Tax();
                    tax.setAmount(ReservationBuilderHelper.getOriginalChargeAmount(charge));
                    tax.setEquivalentAmount(tax.getAmount().getValue());
                    tax.setCode(charge.getCodeType().trim());
                    tax.setSegmentTariff(st);
                    prod.getTaxes().add(tax);
                }
            }
            for (Traveller tr : travellers) {
                if (!tr.getPassport().getFirstName().equalsIgnoreCase(person.getFirstName()) || !tr.getPassport().getLastName().equalsIgnoreCase(person.getLastName()) || FlyDubaiHelper.calcAge(tr.getPassport().getBirthday()) != person.getAge()) continue;
                prod.setTraveller(tr);
                break;
            }
            prod.setReservation(res);
            res.getProducts().add(prod);
        }
        return res;
    }

    private static Money getOriginalChargeAmount(Charge charge) {
        Money amount = new Money();
        amount.setValue(FlyDubaiHelper.round(charge.getOriginalAmount()));
        amount.setCurrency(charge.getOriginalCurrency());
        return amount;
    }

    private static List<Charge> getCharges(LogicalFlight lFlight, AirlinePerson person) {
        ArrayList<Charge> result = new ArrayList<Charge>();
        for (PhysicalFlight pFlight : lFlight.getPhysicalFlights().getPhysicalFlightList()) {
            List persons = ((Customer)pFlight.getCustomers().getCustomerList().get(0)).getAirlinePersons().getAirlinePersonList();
            for (AirlinePerson aperson : persons) {
                if (aperson.getPersonOrgID() != person.getPersonOrgID() || aperson.getCharges().getChargeList() == null) continue;
                result.addAll(aperson.getCharges().getChargeList());
            }
        }
        return result;
    }

    private static SegmentTariff createSegmentTariff(LogicalFlight fdFlight, AirlinePerson p, Flight flight, List<Charge> charges) throws Exception {
        DictionaryReference<PassengerType> ptRef = FlyDubaiHelper.convertIntToPassengerType(p.getPTCID());
        SegmentTariff st = new SegmentTariff();
        ArrayList orderedFlights = new ArrayList(fdFlight.getPhysicalFlights().getPhysicalFlightList());
        Collections.sort(orderedFlights, new Comparator<PhysicalFlight>(){

            @Override
            public int compare(PhysicalFlight o1, PhysicalFlight o2) {
                return o1.getDepartureTime().compareTo(o2.getDepartureTime());
            }
        });
        boolean starting = true;
        for (PhysicalFlight ff : orderedFlights) {
            boolean found = false;
            AirlinePerson flightPerson = (AirlinePerson)MiscUtil.guarded((Object)ReservationBuilderHelper.findAirlinePerson(ff, p.getPersonOrgID()), (Object)p);
            block1: for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
                for (FlightSegment fs : fst.getSegments()) {
                    if (!ff.getPhysicalFlightID().toString().equals(fs.getGdsId())) continue;
                    FareInfo fi = null;
                    for (FareInfo fi1 : fs.getFareInfos()) {
                        if (!MiscUtil.equals((Object)fi1.getPassengerType(), ptRef)) continue;
                        fi = fi1;
                        break;
                    }
                    Segment seg = new Segment();
                    seg.setStartDate(fs.getDateBegin());
                    seg.setEndDate(fs.getDateEnd());
                    seg.setNotValidBefore(seg.getStartDate());
                    seg.setNotValidAfter(seg.getEndDate());
                    seg.setStarting(starting);
                    starting = false;
                    seg.setDepartureLocation(FlyDubaiHelper.resolveNativeCode(GeoLocation.class, ff.getOrigin().trim()));
                    seg.setArriveLocation(FlyDubaiHelper.resolveNativeCode(GeoLocation.class, ff.getDestination().trim()));
                    seg.setFlightNo(ff.getFlightNumber());
                    seg.setAirline(FlyDubaiHelper.resolveNativeCode(Airline.class, ff.getCarrierCode().trim()));
                    seg.setFareBasis(flightPerson.getFareBasisCode());
                    seg.setBoard(fs.getBoard());
                    seg.setServiceClass(fs.getServiceClass());
                    seg.setClassOfSvcCode(fs.getBookingClass());
                    seg.setCodeShareCarrier(fs.getOperatingAirline());
                    seg.setCodeShare(!seg.getAirline().equals((Object)seg.getCodeShareCarrier()));
                    seg.setFlightDuration(Integer.valueOf(fs.getTravelDuration()));
                    seg.setRemarksSearchContext(fi.getRemarksSearchContext());
                    for (Charge charge : charges) {
                        if (!FlyDubaiHelper.isBaggageTaxCode(charge.getCodeType())) continue;
                        seg.setLuggageInfo(AirProductHelper.parseLuggageInfo((String)charge.getDescription().substring(0, charge.getDescription().indexOf(" "))));
                    }
                    if (seg.getLuggageInfo() == null) {
                        seg.setLuggageInfo(AirProductHelper.buildNilLuggageInfo());
                    }
                    if (ff.getPhysicalFlightID() != null) {
                        seg.setGdsId(ff.getPhysicalFlightID().toString());
                    }
                    st.getSegments().add(seg);
                    found = true;
                    continue block1;
                }
            }
            if (found) continue;
            throw Xeption.forDeveloper((String)"No segment found fo physical flight {0}", (Object[])new Object[]{ff.getPhysicalFlightID()});
        }
        return st;
    }

    public static Map<Integer, AirlinePerson> getPassangers(ViewPNR pnr) {
        HashMap<Integer, AirlinePerson> result = new HashMap<Integer, AirlinePerson>();
        LogicalFlight lflight = (LogicalFlight)((org.datacontract.schemas.radixx.connectpoint.reservation.Airline)pnr.getAirlines().getAirlineList().get(0)).getLogicalFlight().getLogicalFlightList().get(0);
        PhysicalFlight phflight = (PhysicalFlight)lflight.getPhysicalFlights().getPhysicalFlightList().get(0);
        List persons = ((Customer)phflight.getCustomers().getCustomerList().get(0)).getAirlinePersons().getAirlinePersonList();
        for (AirlinePerson person : persons) {
            Integer orgId = person.getPersonOrgID();
            result.put(orgId, person);
        }
        return result;
    }

    public static AirlinePerson findAirlinePerson(PhysicalFlight phflight, Integer personOrgId) {
        List persons = ((Customer)phflight.getCustomers().getCustomerList().get(0)).getAirlinePersons().getAirlinePersonList();
        for (AirlinePerson person : persons) {
            if (!personOrgId.equals(person.getPersonOrgID())) continue;
            return person;
        }
        return null;
    }
}

