
package org.datacontract.schemas.radixx.connectpoint;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enumerations.AnswerTypes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="No"/>
 *     &lt;xs:enumeration value="Yes"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumerationsAnswerTypes {
    NO("No"), YES("Yes");
    private final String value;

    private EnumerationsAnswerTypes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumerationsAnswerTypes convert(String value) {
        for (EnumerationsAnswerTypes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
