
package org.datacontract.schemas.radixx.connectpoint;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enumerations.PaymentMethodTypes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="AMEX"/>
 *     &lt;xs:enumeration value="DCLB"/>
 *     &lt;xs:enumeration value="DSCV"/>
 *     &lt;xs:enumeration value="MSCD"/>
 *     &lt;xs:enumeration value="UATP"/>
 *     &lt;xs:enumeration value="VISA"/>
 *     &lt;xs:enumeration value="INVC"/>
 *     &lt;xs:enumeration value="SAPI"/>
 *     &lt;xs:enumeration value="TKNE"/>
 *     &lt;xs:enumeration value="CASH"/>
 *     &lt;xs:enumeration value="CHCK"/>
 *     &lt;xs:enumeration value="TCHK"/>
 *     &lt;xs:enumeration value="TCKT"/>
 *     &lt;xs:enumeration value="VCHR"/>
 *     &lt;xs:enumeration value="PL8R"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumerationsPaymentMethodTypes {
    AMEX("AMEX"), DCLB("DCLB"), DSCV("DSCV"), MSCD("MSCD"), UATP("UATP"), VISA(
            "VISA"), INVC("INVC"), SAPI("SAPI"), TKNE("TKNE"), CASH("CASH"), CHCK(
            "CHCK"), TCHK("TCHK"), TCKT("TCKT"), VCHR("VCHR"), P_L8_R("PL8R");
    private final String value;

    private EnumerationsPaymentMethodTypes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumerationsPaymentMethodTypes convert(String value) {
        for (EnumerationsPaymentMethodTypes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
