
package org.datacontract.schemas.radixx.connectpoint;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enumerations.RelationshipTypes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Self"/>
 *     &lt;xs:enumeration value="Spouse"/>
 *     &lt;xs:enumeration value="Father"/>
 *     &lt;xs:enumeration value="Mother"/>
 *     &lt;xs:enumeration value="Son"/>
 *     &lt;xs:enumeration value="Daughter"/>
 *     &lt;xs:enumeration value="GrandFather"/>
 *     &lt;xs:enumeration value="GrandMother"/>
 *     &lt;xs:enumeration value="Uncle"/>
 *     &lt;xs:enumeration value="Aunt"/>
 *     &lt;xs:enumeration value="Nephew"/>
 *     &lt;xs:enumeration value="Niece"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumerationsRelationshipTypes {
    SELF("Self"), SPOUSE("Spouse"), FATHER("Father"), MOTHER("Mother"), SON(
            "Son"), DAUGHTER("Daughter"), GRAND_FATHER("GrandFather"), GRAND_MOTHER(
            "GrandMother"), UNCLE("Uncle"), AUNT("Aunt"), NEPHEW("Nephew"), NIECE(
            "Niece");
    private final String value;

    private EnumerationsRelationshipTypes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumerationsRelationshipTypes convert(String value) {
        for (EnumerationsRelationshipTypes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
