
package org.datacontract.schemas.radixx.connectpoint;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enumerations.SegmentStatus">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Cancelled"/>
 *     &lt;xs:enumeration value="Active"/>
 *     &lt;xs:enumeration value="WaitList"/>
 *     &lt;xs:enumeration value="StandBy"/>
 *     &lt;xs:enumeration value="CheckedIn"/>
 *     &lt;xs:enumeration value="Boarded"/>
 *     &lt;xs:enumeration value="Flying"/>
 *     &lt;xs:enumeration value="Flown"/>
 *     &lt;xs:enumeration value="Hold"/>
 *     &lt;xs:enumeration value="NoShow"/>
 *     &lt;xs:enumeration value="Confirm"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumerationsSegmentStatus {
    CANCELLED("Cancelled"), ACTIVE("Active"), WAIT_LIST("WaitList"), STAND_BY(
            "StandBy"), CHECKED_IN("CheckedIn"), BOARDED("Boarded"), FLYING(
            "Flying"), FLOWN("Flown"), HOLD("Hold"), NO_SHOW("NoShow"), CONFIRM(
            "Confirm");
    private final String value;

    private EnumerationsSegmentStatus(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumerationsSegmentStatus convert(String value) {
        for (EnumerationsSegmentStatus inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
