
package org.datacontract.schemas.radixx.connectpoint;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Exceptions" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExceptionLevels">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Success"/>
 *     &lt;xs:enumeration value="Warning"/>
 *     &lt;xs:enumeration value="Critical"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ExceptionLevels {
    SUCCESS("Success"), WARNING("Warning"), CRITICAL("Critical");
    private final String value;

    private ExceptionLevels(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ExceptionLevels convert(String value) {
        for (ExceptionLevels inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
