
package org.datacontract.schemas.radixx.connectpoint;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TransactionInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="SecurityGUID"/>
 *     &lt;xs:element type="ns:ArrayOfCarrierCode" nillable="true" name="CarrierCodes"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ClientIPAddress" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="HistoricUserName" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TransactionInfo
{
    private String securityGUID;
    private ArrayOfCarrierCode carrierCodes;
    private String clientIPAddress;
    private String historicUserName;

    /** 
     * Get the 'SecurityGUID' element value. Description: .Constraints: Required.
    					Range: Length must be in the range 1 and
    					2147483647.
    				
     * 
     * @return value
     */
    public String getSecurityGUID() {
        return securityGUID;
    }

    /** 
     * Set the 'SecurityGUID' element value. Description: .Constraints: Required.
    					Range: Length must be in the range 1 and
    					2147483647.
    				
     * 
     * @param securityGUID
     */
    public void setSecurityGUID(String securityGUID) {
        this.securityGUID = securityGUID;
    }

    /** 
     * Get the 'CarrierCodes' element value. Description: .Constraints: Required.
    					Range: Value must be in the range 1 and
    					2147483647.
    				
     * 
     * @return value
     */
    public ArrayOfCarrierCode getCarrierCodes() {
        return carrierCodes;
    }

    /** 
     * Set the 'CarrierCodes' element value. Description: .Constraints: Required.
    					Range: Value must be in the range 1 and
    					2147483647.
    				
     * 
     * @param carrierCodes
     */
    public void setCarrierCodes(ArrayOfCarrierCode carrierCodes) {
        this.carrierCodes = carrierCodes;
    }

    /** 
     * Get the 'ClientIPAddress' element value. 
    					Description: The value supplied in this property
    					represent the Consumers IP
    					address. The connect point integrator
    					will need to capture this
    					information from the browser object.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getClientIPAddress() {
        return clientIPAddress;
    }

    /** 
     * Set the 'ClientIPAddress' element value. 
    					Description: The value supplied in this property
    					represent the Consumers IP
    					address. The connect point integrator
    					will need to capture this
    					information from the browser object.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param clientIPAddress
     */
    public void setClientIPAddress(String clientIPAddress) {
        this.clientIPAddress = clientIPAddress;
    }

    /** 
     * Get the 'HistoricUserName' element value. 
    					Description: The value supplied in this property
    					the user name that will be
    					associated to the history record, in the
    					event that the object for
    					the action being performed does not have
    					a UserName property. Note
    					the property is option so that existing
    					Data Contracts are still
    					honored..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 0 and 15.
    				
     * 
     * @return value
     */
    public String getHistoricUserName() {
        return historicUserName;
    }

    /** 
     * Set the 'HistoricUserName' element value. 
    					Description: The value supplied in this property
    					the user name that will be
    					associated to the history record, in the
    					event that the object for
    					the action being performed does not have
    					a UserName property. Note
    					the property is option so that existing
    					Data Contracts are still
    					honored..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 0 and 15.
    				
     * 
     * @param historicUserName
     */
    public void setHistoricUserName(String historicUserName) {
        this.historicUserName = historicUserName;
    }
}
