
package org.datacontract.schemas.radixx.connectpoint.fulfillment;

import java.math.BigDecimal;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsCurrencyCodeTypes;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Fulfillment.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrencyConversion">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Enumerations.CurrencyCodeTypes" name="CurrencyToConvertFrom"/>
 *     &lt;xs:element type="ns:Enumerations.CurrencyCodeTypes" name="CurrencyToConvertTo"/>
 *     &lt;xs:element type="xs:decimal" name="AmountToConvert"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CurrencyConversion
{
    private EnumerationsCurrencyCodeTypes currencyToConvertFrom;
    private EnumerationsCurrencyCodeTypes currencyToConvertTo;
    private BigDecimal amountToConvert;

    /** 
     * Get the 'CurrencyToConvertFrom' element value. 
    					Description: Currency which Radixx.ConnectPoint.needs to Convert From.
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsCurrencyCodeTypes getCurrencyToConvertFrom() {
        return currencyToConvertFrom;
    }

    /** 
     * Set the 'CurrencyToConvertFrom' element value. 
    					Description: Currency which Radixx.ConnectPoint.needs to Convert From.
    				Constraints: Required.
     * 
     * @param currencyToConvertFrom
     */
    public void setCurrencyToConvertFrom(
            EnumerationsCurrencyCodeTypes currencyToConvertFrom) {
        this.currencyToConvertFrom = currencyToConvertFrom;
    }

    /** 
     * Get the 'CurrencyToConvertTo' element value. 
    					Description: Currency which Radixx.ConnectPoint.needs to Convert to.
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsCurrencyCodeTypes getCurrencyToConvertTo() {
        return currencyToConvertTo;
    }

    /** 
     * Set the 'CurrencyToConvertTo' element value. 
    					Description: Currency which Radixx.ConnectPoint.needs to Convert to.
    				Constraints: Required.
     * 
     * @param currencyToConvertTo
     */
    public void setCurrencyToConvertTo(
            EnumerationsCurrencyCodeTypes currencyToConvertTo) {
        this.currencyToConvertTo = currencyToConvertTo;
    }

    /** 
     * Get the 'AmountToConvert' element value. 
    					Description: Currency amount needing to be converted.
    				Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getAmountToConvert() {
        return amountToConvert;
    }

    /** 
     * Set the 'AmountToConvert' element value. 
    					Description: Currency amount needing to be converted.
    				Constraints: Required.
     * 
     * @param amountToConvert
     */
    public void setAmountToConvert(BigDecimal amountToConvert) {
        this.amountToConvert = amountToConvert;
    }
}
