
package org.datacontract.schemas.radixx.connectpoint.fulfillment;

import java.math.BigDecimal;
import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsCurrencyCodeTypes;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Fulfillment.Response" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrencyConversion">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns1:Enumerations.CurrencyCodeTypes" name="CurrencyToConvertFrom"/>
 *     &lt;xs:element type="ns1:Enumerations.CurrencyCodeTypes" name="CurrencyToConvertTo"/>
 *     &lt;xs:element type="xs:decimal" name="AmountPriorToConversion"/>
 *     &lt;xs:element type="xs:decimal" name="ConvertedAmount"/>
 *     &lt;xs:element type="xs:decimal" name="ExchangeRate"/>
 *     &lt;xs:element type="xs:dateTime" name="ExchangeRateDate"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CurrencyConversion1
{
    private EnumerationsCurrencyCodeTypes currencyToConvertFrom;
    private EnumerationsCurrencyCodeTypes currencyToConvertTo;
    private BigDecimal amountPriorToConversion;
    private BigDecimal convertedAmount;
    private BigDecimal exchangeRate;
    private Date exchangeRateDate;

    /** 
     * Get the 'CurrencyToConvertFrom' element value. 
    					Description: Currency which Radixx.ConnectPoint.Convert From.
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsCurrencyCodeTypes getCurrencyToConvertFrom() {
        return currencyToConvertFrom;
    }

    /** 
     * Set the 'CurrencyToConvertFrom' element value. 
    					Description: Currency which Radixx.ConnectPoint.Convert From.
    				Constraints: Required.
     * 
     * @param currencyToConvertFrom
     */
    public void setCurrencyToConvertFrom(
            EnumerationsCurrencyCodeTypes currencyToConvertFrom) {
        this.currencyToConvertFrom = currencyToConvertFrom;
    }

    /** 
     * Get the 'CurrencyToConvertTo' element value. 
    					Description: Currency which Radixx.ConnectPoint.Convert to.
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsCurrencyCodeTypes getCurrencyToConvertTo() {
        return currencyToConvertTo;
    }

    /** 
     * Set the 'CurrencyToConvertTo' element value. 
    					Description: Currency which Radixx.ConnectPoint.Convert to.
    				Constraints: Required.
     * 
     * @param currencyToConvertTo
     */
    public void setCurrencyToConvertTo(
            EnumerationsCurrencyCodeTypes currencyToConvertTo) {
        this.currencyToConvertTo = currencyToConvertTo;
    }

    /** 
     * Get the 'AmountPriorToConversion' element value. 
    					Description: Currency amount that needed to be converted.
    				Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getAmountPriorToConversion() {
        return amountPriorToConversion;
    }

    /** 
     * Set the 'AmountPriorToConversion' element value. 
    					Description: Currency amount that needed to be converted.
    				Constraints: Required.
     * 
     * @param amountPriorToConversion
     */
    public void setAmountPriorToConversion(BigDecimal amountPriorToConversion) {
        this.amountPriorToConversion = amountPriorToConversion;
    }

    /** 
     * Get the 'ConvertedAmount' element value. Description: Converted Amount.Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getConvertedAmount() {
        return convertedAmount;
    }

    /** 
     * Set the 'ConvertedAmount' element value. Description: Converted Amount.Constraints: Required.
     * 
     * @param convertedAmount
     */
    public void setConvertedAmount(BigDecimal convertedAmount) {
        this.convertedAmount = convertedAmount;
    }

    /** 
     * Get the 'ExchangeRate' element value. 
    					Description: The Exchange Rate that was used to do the conversion.
    				Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getExchangeRate() {
        return exchangeRate;
    }

    /** 
     * Set the 'ExchangeRate' element value. 
    					Description: The Exchange Rate that was used to do the conversion.
    				Constraints: Required.
     * 
     * @param exchangeRate
     */
    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    /** 
     * Get the 'ExchangeRateDate' element value. 
    					Description: The date that the exchange rate was entered in to the system.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getExchangeRateDate() {
        return exchangeRateDate;
    }

    /** 
     * Set the 'ExchangeRateDate' element value. 
    					Description: The date that the exchange rate was entered in to the system.
    				Constraints: Required.
     * 
     * @param exchangeRateDate
     */
    public void setExchangeRateDate(Date exchangeRateDate) {
        this.exchangeRateDate = exchangeRateDate;
    }
}
