
package org.datacontract.schemas.radixx.connectpoint.fulfillment;

import org.datacontract.schemas.radixx.connectpoint.ReservationInfo;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Fulfillment.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExternalProcessedPayments">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TransactionInfo" nillable="true" name="TransactionInfo"/>
 *     &lt;xs:element type="ns:ReservationInfo" nillable="true" name="ReservationInfo"/>
 *     &lt;xs:element type="ns1:ArrayOfInsertExternalProcessedPayment" nillable="true" name="ExternalPayments"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ExternalProcessedPayments
{
    private TransactionInfo transactionInfo;
    private ReservationInfo reservationInfo;
    private ArrayOfInsertExternalProcessedPayment externalPayments;

    /** 
     * Get the 'TransactionInfo' element value. Description: .Constraints: Required.
     * 
     * @return value
     */
    public TransactionInfo getTransactionInfo() {
        return transactionInfo;
    }

    /** 
     * Set the 'TransactionInfo' element value. Description: .Constraints: Required.
     * 
     * @param transactionInfo
     */
    public void setTransactionInfo(TransactionInfo transactionInfo) {
        this.transactionInfo = transactionInfo;
    }

    /** 
     * Get the 'ReservationInfo' element value. Description: .Constraints: Required.
     * 
     * @return value
     */
    public ReservationInfo getReservationInfo() {
        return reservationInfo;
    }

    /** 
     * Set the 'ReservationInfo' element value. Description: .Constraints: Required.
     * 
     * @param reservationInfo
     */
    public void setReservationInfo(ReservationInfo reservationInfo) {
        this.reservationInfo = reservationInfo;
    }

    /** 
     * Get the 'ExternalPayments' element value. Description: .Constraints: Required.Range: Value must be in the range 1 and 20.
    				
     * 
     * @return value
     */
    public ArrayOfInsertExternalProcessedPayment getExternalPayments() {
        return externalPayments;
    }

    /** 
     * Set the 'ExternalPayments' element value. Description: .Constraints: Required.Range: Value must be in the range 1 and 20.
    				
     * 
     * @param externalPayments
     */
    public void setExternalPayments(
            ArrayOfInsertExternalProcessedPayment externalPayments) {
        this.externalPayments = externalPayments;
    }
}
