
package org.datacontract.schemas.radixx.connectpoint.fulfillment;

import org.datacontract.schemas.radixx.connectpoint.ReservationInfo;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Fulfillment.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Format3DSecureInformation">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns1:Format3DSecureInformation.ActionTypes" name="ActionType"/>
 *         &lt;xs:element type="ns:ReservationInfo" nillable="true" name="ReservationInfo"/>
 *         &lt;xs:element type="xs:int" name="ReservationPaymentId"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="ReturnURL"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Format3DSecureInformation extends TransactionInfo
{
    private Format3DSecureInformationActionTypes actionType;
    private ReservationInfo reservationInfo;
    private int reservationPaymentId;
    private String returnURL;

    /** 
     * Get the 'ActionType' element value. 
    							Description: Defines the action the Radixx.ConnectPoint.consumer is wanting
    							to take.
    						Constraints: Required.
     * 
     * @return value
     */
    public Format3DSecureInformationActionTypes getActionType() {
        return actionType;
    }

    /** 
     * Set the 'ActionType' element value. 
    							Description: Defines the action the Radixx.ConnectPoint.consumer is wanting
    							to take.
    						Constraints: Required.
     * 
     * @param actionType
     */
    public void setActionType(Format3DSecureInformationActionTypes actionType) {
        this.actionType = actionType;
    }

    /** 
     * Get the 'ReservationInfo' element value. 
    							Description: Reservation Information which is needed to allow for cross
    							check on processing.
    						Constraints: Required.
     * 
     * @return value
     */
    public ReservationInfo getReservationInfo() {
        return reservationInfo;
    }

    /** 
     * Set the 'ReservationInfo' element value. 
    							Description: Reservation Information which is needed to allow for cross
    							check on processing.
    						Constraints: Required.
     * 
     * @param reservationInfo
     */
    public void setReservationInfo(ReservationInfo reservationInfo) {
        this.reservationInfo = reservationInfo;
    }

    /** 
     * Get the 'ReservationPaymentId' element value. 
    							Description: The database level unique identifier for the payment to be
    							Authenticated.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public int getReservationPaymentId() {
        return reservationPaymentId;
    }

    /** 
     * Set the 'ReservationPaymentId' element value. 
    							Description: The database level unique identifier for the payment to be
    							Authenticated.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param reservationPaymentId
     */
    public void setReservationPaymentId(int reservationPaymentId) {
        this.reservationPaymentId = reservationPaymentId;
    }

    /** 
     * Get the 'ReturnURL' element value. 
    							Description: The URL that the 3D secure provider will redirect to once the
    							3D secure login has been performed.
    						Constraints: Required.
     * 
     * @return value
     */
    public String getReturnURL() {
        return returnURL;
    }

    /** 
     * Set the 'ReturnURL' element value. 
    							Description: The URL that the 3D secure provider will redirect to once the
    							3D secure login has been performed.
    						Constraints: Required.
     * 
     * @param returnURL
     */
    public void setReturnURL(String returnURL) {
        this.returnURL = returnURL;
    }
}
