
package org.datacontract.schemas.radixx.connectpoint.fulfillment;

import org.datacontract.schemas.radixx.connectpoint.ReservationInfo;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Fulfillment.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PNRPayments">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TransactionInfo" nillable="true" name="TransactionInfo"/>
 *     &lt;xs:element type="ns:ReservationInfo" nillable="true" name="ReservationInfo"/>
 *     &lt;xs:element type="ns1:ArrayOfProcessPNRPayment" nillable="true" name="PNRPayments"/>
 *     &lt;xs:element type="ns1:PNRPayments.ActionTypes" name="ActionType" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PNRPayments
{
    private TransactionInfo transactionInfo;
    private ReservationInfo reservationInfo;
    private ArrayOfProcessPNRPayment PNRPayments1;
    private PNRPaymentsActionTypes actionType;

    /** 
     * Get the 'TransactionInfo' element value. Description: .Constraints: Required.
     * 
     * @return value
     */
    public TransactionInfo getTransactionInfo() {
        return transactionInfo;
    }

    /** 
     * Set the 'TransactionInfo' element value. Description: .Constraints: Required.
     * 
     * @param transactionInfo
     */
    public void setTransactionInfo(TransactionInfo transactionInfo) {
        this.transactionInfo = transactionInfo;
    }

    /** 
     * Get the 'ReservationInfo' element value. Description: .Constraints: Required.
     * 
     * @return value
     */
    public ReservationInfo getReservationInfo() {
        return reservationInfo;
    }

    /** 
     * Set the 'ReservationInfo' element value. Description: .Constraints: Required.
     * 
     * @param reservationInfo
     */
    public void setReservationInfo(ReservationInfo reservationInfo) {
        this.reservationInfo = reservationInfo;
    }

    /** 
     * Get the 'PNRPayments' element value. Description: .Constraints: Required.Range: Value must be in the range 1 and 20.
    				
     * 
     * @return value
     */
    public ArrayOfProcessPNRPayment getPNRPayments1() {
        return PNRPayments1;
    }

    /** 
     * Set the 'PNRPayments' element value. Description: .Constraints: Required.Range: Value must be in the range 1 and 20.
    				
     * 
     * @param PNRPayments1
     */
    public void setPNRPayments1(ArrayOfProcessPNRPayment PNRPayments1) {
        this.PNRPayments1 = PNRPayments1;
    }

    /** 
     * Get the 'ActionType' element value. 
    					Description: Action type indicating the option process PNR payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public PNRPaymentsActionTypes getActionType() {
        return actionType;
    }

    /** 
     * Set the 'ActionType' element value. 
    					Description: Action type indicating the option process PNR payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param actionType
     */
    public void setActionType(PNRPaymentsActionTypes actionType) {
        this.actionType = actionType;
    }
}
