
package org.datacontract.schemas.radixx.connectpoint.fulfillment;

import org.datacontract.schemas.radixx.connectpoint.ReservationInfo;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Fulfillment.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpdateExternalProcessedPayment">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns1:UpdateExternalProcessedPayment.ActionTypes" name="ActionType"/>
 *         &lt;xs:element type="ns:ReservationInfo" nillable="true" name="ReservationInfo"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="ResponseFrom3DSecure"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class UpdateExternalProcessedPayment extends TransactionInfo
{
    private UpdateExternalProcessedPaymentActionTypes actionType;
    private ReservationInfo reservationInfo;
    private String responseFrom3DSecure;

    /** 
     * Get the 'ActionType' element value. 
    							Description: Defines the action the Radixx.ConnectPoint.consumer is wanting
    							to take.
    						Constraints: Required.
     * 
     * @return value
     */
    public UpdateExternalProcessedPaymentActionTypes getActionType() {
        return actionType;
    }

    /** 
     * Set the 'ActionType' element value. 
    							Description: Defines the action the Radixx.ConnectPoint.consumer is wanting
    							to take.
    						Constraints: Required.
     * 
     * @param actionType
     */
    public void setActionType(
            UpdateExternalProcessedPaymentActionTypes actionType) {
        this.actionType = actionType;
    }

    /** 
     * Get the 'ReservationInfo' element value. 
    							Description: Reservation Information which is needed to allow for cross
    							check on processing.
    						Constraints: Required.
     * 
     * @return value
     */
    public ReservationInfo getReservationInfo() {
        return reservationInfo;
    }

    /** 
     * Set the 'ReservationInfo' element value. 
    							Description: Reservation Information which is needed to allow for cross
    							check on processing.
    						Constraints: Required.
     * 
     * @param reservationInfo
     */
    public void setReservationInfo(ReservationInfo reservationInfo) {
        this.reservationInfo = reservationInfo;
    }

    /** 
     * Get the 'ResponseFrom3DSecure' element value. 
    							Description: The response that is returned by the 3D secure provider.
    						Constraints: Required.
     * 
     * @return value
     */
    public String getResponseFrom3DSecure() {
        return responseFrom3DSecure;
    }

    /** 
     * Set the 'ResponseFrom3DSecure' element value. 
    							Description: The response that is returned by the 3D secure provider.
    						Constraints: Required.
     * 
     * @param responseFrom3DSecure
     */
    public void setResponseFrom3DSecure(String responseFrom3DSecure) {
        this.responseFrom3DSecure = responseFrom3DSecure;
    }
}
