
package org.datacontract.schemas.radixx.connectpoint.fulfillment;

import org.datacontract.schemas.radixx.connectpoint.ExceptionInformationExceptions;

/** 
 * 
 <summary> The resulting object and properties will be used by the
 consuming client to build the the Form Post that will be submitted
 to MIGS for 3D Secure authentication </summary>

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Fulfillment.Response" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Exceptions" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ViewFormatted3DSecureInformation">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="vpc_AccessCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="vpc_Amount"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="vpc_Command"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="vpc_Locale"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="vpc_MerchTxnRef"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="vpc_Merchant"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="vpc_OrderInfo"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="vpc_ReturnURL"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="vpc_TicketNo"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="vpc_Version"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="vpc_gateway"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="vpc_card"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="vpc_CardNum"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="vpc_CardExp"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="vpc_AddendumData"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="SubDelimeter"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="MainDelimeter"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="vpc_SecureHash"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Raw3DRequest"/>
 *     &lt;xs:element type="ns1:ExceptionInformation.Exceptions" nillable="true" name="Exceptions"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ViewFormatted3DSecureInformation
{
    private String vpcAccessCode;
    private String vpcAmount;
    private String vpcCommand;
    private String vpcLocale;
    private String vpcMerchTxnRef;
    private String vpcMerchant;
    private String vpcOrderInfo;
    private String vpcReturnURL;
    private String vpcTicketNo;
    private String vpcVersion;
    private String vpcGateway;
    private String vpcCard;
    private String vpcCardNum;
    private String vpcCardExp;
    private String vpcAddendumData;
    private String subDelimeter;
    private String mainDelimeter;
    private String vpcSecureHash;
    private String raw3DRequest;
    private ExceptionInformationExceptions exceptions;

    /** 
     * Get the 'vpc_AccessCode' element value. 
    					Description: 3D Secure processing gateway supplied values.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getVpcAccessCode() {
        return vpcAccessCode;
    }

    /** 
     * Set the 'vpc_AccessCode' element value. 
    					Description: 3D Secure processing gateway supplied values.
    				Constraints: Required.
     * 
     * @param vpcAccessCode
     */
    public void setVpcAccessCode(String vpcAccessCode) {
        this.vpcAccessCode = vpcAccessCode;
    }

    /** 
     * Get the 'vpc_Amount' element value. 
    					Description: The total amount of the payment that will be submitted.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getVpcAmount() {
        return vpcAmount;
    }

    /** 
     * Set the 'vpc_Amount' element value. 
    					Description: The total amount of the payment that will be submitted.
    				Constraints: Required.
     * 
     * @param vpcAmount
     */
    public void setVpcAmount(String vpcAmount) {
        this.vpcAmount = vpcAmount;
    }

    /** 
     * Get the 'vpc_Command' element value. 
    					Description: 3D Secure processing gateway supplied values.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getVpcCommand() {
        return vpcCommand;
    }

    /** 
     * Set the 'vpc_Command' element value. 
    					Description: 3D Secure processing gateway supplied values.
    				Constraints: Required.
     * 
     * @param vpcCommand
     */
    public void setVpcCommand(String vpcCommand) {
        this.vpcCommand = vpcCommand;
    }

    /** 
     * Get the 'vpc_Locale' element value. Description: defaulted language code.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getVpcLocale() {
        return vpcLocale;
    }

    /** 
     * Set the 'vpc_Locale' element value. Description: defaulted language code.
    				Constraints: Required.
     * 
     * @param vpcLocale
     */
    public void setVpcLocale(String vpcLocale) {
        this.vpcLocale = vpcLocale;
    }

    /** 
     * Get the 'vpc_MerchTxnRef' element value. 
    					Description: Value created by internal system logic.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getVpcMerchTxnRef() {
        return vpcMerchTxnRef;
    }

    /** 
     * Set the 'vpc_MerchTxnRef' element value. 
    					Description: Value created by internal system logic.
    				Constraints: Required.
     * 
     * @param vpcMerchTxnRef
     */
    public void setVpcMerchTxnRef(String vpcMerchTxnRef) {
        this.vpcMerchTxnRef = vpcMerchTxnRef;
    }

    /** 
     * Get the 'vpc_Merchant' element value. 
    					Description: 3D Secure processing gateway supplied values.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getVpcMerchant() {
        return vpcMerchant;
    }

    /** 
     * Set the 'vpc_Merchant' element value. 
    					Description: 3D Secure processing gateway supplied values.
    				Constraints: Required.
     * 
     * @param vpcMerchant
     */
    public void setVpcMerchant(String vpcMerchant) {
        this.vpcMerchant = vpcMerchant;
    }

    /** 
     * Get the 'vpc_OrderInfo' element value. 
    					Description: Value created by internal system logic.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getVpcOrderInfo() {
        return vpcOrderInfo;
    }

    /** 
     * Set the 'vpc_OrderInfo' element value. 
    					Description: Value created by internal system logic.
    				Constraints: Required.
     * 
     * @param vpcOrderInfo
     */
    public void setVpcOrderInfo(String vpcOrderInfo) {
        this.vpcOrderInfo = vpcOrderInfo;
    }

    /** 
     * Get the 'vpc_ReturnURL' element value. 
    					Description: This value is populated with the ReturnURL that would have been
    					submitted in the request.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getVpcReturnURL() {
        return vpcReturnURL;
    }

    /** 
     * Set the 'vpc_ReturnURL' element value. 
    					Description: This value is populated with the ReturnURL that would have been
    					submitted in the request.
    				Constraints: Required.
     * 
     * @param vpcReturnURL
     */
    public void setVpcReturnURL(String vpcReturnURL) {
        this.vpcReturnURL = vpcReturnURL;
    }

    /** 
     * Get the 'vpc_TicketNo' element value. 
    					Description: Value created by internal system logic.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getVpcTicketNo() {
        return vpcTicketNo;
    }

    /** 
     * Set the 'vpc_TicketNo' element value. 
    					Description: Value created by internal system logic.
    				Constraints: Required.
     * 
     * @param vpcTicketNo
     */
    public void setVpcTicketNo(String vpcTicketNo) {
        this.vpcTicketNo = vpcTicketNo;
    }

    /** 
     * Get the 'vpc_Version' element value. 
    					Description: 3D Secure processing gateway supplied values.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getVpcVersion() {
        return vpcVersion;
    }

    /** 
     * Set the 'vpc_Version' element value. 
    					Description: 3D Secure processing gateway supplied values.
    				Constraints: Required.
     * 
     * @param vpcVersion
     */
    public void setVpcVersion(String vpcVersion) {
        this.vpcVersion = vpcVersion;
    }

    /** 
     * Get the 'vpc_gateway' element value. 
    					Description: 3D Secure processing gateway supplied values.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getVpcGateway() {
        return vpcGateway;
    }

    /** 
     * Set the 'vpc_gateway' element value. 
    					Description: 3D Secure processing gateway supplied values.
    				Constraints: Required.
     * 
     * @param vpcGateway
     */
    public void setVpcGateway(String vpcGateway) {
        this.vpcGateway = vpcGateway;
    }

    /** 
     * Get the 'vpc_card' element value. 
    					Description: The payment method that was submitted to cover the balance due on
    					the PNR.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getVpcCard() {
        return vpcCard;
    }

    /** 
     * Set the 'vpc_card' element value. 
    					Description: The payment method that was submitted to cover the balance due on
    					the PNR.
    				Constraints: Required.
     * 
     * @param vpcCard
     */
    public void setVpcCard(String vpcCard) {
        this.vpcCard = vpcCard;
    }

    /** 
     * Get the 'vpc_CardNum' element value. 
    					Description: The card number of the payment method that was submitted to cover
    					the balance due on the PNR.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getVpcCardNum() {
        return vpcCardNum;
    }

    /** 
     * Set the 'vpc_CardNum' element value. 
    					Description: The card number of the payment method that was submitted to cover
    					the balance due on the PNR.
    				Constraints: Required.
     * 
     * @param vpcCardNum
     */
    public void setVpcCardNum(String vpcCardNum) {
        this.vpcCardNum = vpcCardNum;
    }

    /** 
     * Get the 'vpc_CardExp' element value. 
    					Description: The expiration date of the payment method that was submitted to
    					cover the balance due on the PNR.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getVpcCardExp() {
        return vpcCardExp;
    }

    /** 
     * Set the 'vpc_CardExp' element value. 
    					Description: The expiration date of the payment method that was submitted to
    					cover the balance due on the PNR.
    				Constraints: Required.
     * 
     * @param vpcCardExp
     */
    public void setVpcCardExp(String vpcCardExp) {
        this.vpcCardExp = vpcCardExp;
    }

    /** 
     * Get the 'vpc_AddendumData' element value. Description: Not Specified.Constraints: Required.
     * 
     * @return value
     */
    public String getVpcAddendumData() {
        return vpcAddendumData;
    }

    /** 
     * Set the 'vpc_AddendumData' element value. Description: Not Specified.Constraints: Required.
     * 
     * @param vpcAddendumData
     */
    public void setVpcAddendumData(String vpcAddendumData) {
        this.vpcAddendumData = vpcAddendumData;
    }

    /** 
     * Get the 'SubDelimeter' element value. 
    					Description: The delimeter to use between the keyword and the value.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getSubDelimeter() {
        return subDelimeter;
    }

    /** 
     * Set the 'SubDelimeter' element value. 
    					Description: The delimeter to use between the keyword and the value.
    				Constraints: Required.
     * 
     * @param subDelimeter
     */
    public void setSubDelimeter(String subDelimeter) {
        this.subDelimeter = subDelimeter;
    }

    /** 
     * Get the 'MainDelimeter' element value. 
    					Description: The delimeter to use between each keyword and value pair.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getMainDelimeter() {
        return mainDelimeter;
    }

    /** 
     * Set the 'MainDelimeter' element value. 
    					Description: The delimeter to use between each keyword and value pair.
    				Constraints: Required.
     * 
     * @param mainDelimeter
     */
    public void setMainDelimeter(String mainDelimeter) {
        this.mainDelimeter = mainDelimeter;
    }

    /** 
     * Get the 'vpc_SecureHash' element value. 
    					Description: Hash Value generated as a result of the concat of all of the
    					elements and values.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getVpcSecureHash() {
        return vpcSecureHash;
    }

    /** 
     * Set the 'vpc_SecureHash' element value. 
    					Description: Hash Value generated as a result of the concat of all of the
    					elements and values.
    				Constraints: Required.
     * 
     * @param vpcSecureHash
     */
    public void setVpcSecureHash(String vpcSecureHash) {
        this.vpcSecureHash = vpcSecureHash;
    }

    /** 
     * Get the 'Raw3DRequest' element value. 
    					Description: The RAW representation of the request string that Radixx builds
    					internally.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getRaw3DRequest() {
        return raw3DRequest;
    }

    /** 
     * Set the 'Raw3DRequest' element value. 
    					Description: The RAW representation of the request string that Radixx builds
    					internally.
    				Constraints: Required.
     * 
     * @param raw3DRequest
     */
    public void setRaw3DRequest(String raw3DRequest) {
        this.raw3DRequest = raw3DRequest;
    }

    /** 
     * Get the 'Exceptions' element value. Description: Any exceptions or special cases.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ExceptionInformationExceptions getExceptions() {
        return exceptions;
    }

    /** 
     * Set the 'Exceptions' element value. Description: Any exceptions or special cases.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param exceptions
     */
    public void setExceptions(ExceptionInformationExceptions exceptions) {
        this.exceptions = exceptions;
    }
}
