
package org.datacontract.schemas.radixx.connectpoint.pricing;

import java.math.BigDecimal;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Pricing.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFareInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="FareID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FCCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FBCode"/>
 *     &lt;xs:element type="xs:decimal" name="BaseFareAmtNoTaxes"/>
 *     &lt;xs:element type="xs:decimal" name="BaseFareAmt"/>
 *     &lt;xs:element type="xs:decimal" name="FareAmtNoTaxes"/>
 *     &lt;xs:element type="xs:decimal" name="FareAmt"/>
 *     &lt;xs:element type="xs:decimal" name="BaseFareAmtInclTax"/>
 *     &lt;xs:element type="xs:decimal" name="FareAmtInclTax"/>
 *     &lt;xs:element type="xs:boolean" name="PvtFare"/>
 *     &lt;xs:element type="xs:int" name="PTCID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Cabin"/>
 *     &lt;xs:element type="xs:int" name="SeatsAvailable"/>
 *     &lt;xs:element type="xs:int" name="InfantSeatsAvailable"/>
 *     &lt;xs:element type="xs:int" name="FareScheduleID"/>
 *     &lt;xs:element type="xs:int" name="PromotionID"/>
 *     &lt;xs:element type="xs:int" name="RoundTrip"/>
 *     &lt;xs:element type="xs:decimal" name="DisplayFareAmt"/>
 *     &lt;xs:element type="xs:decimal" name="DisplayTaxSum"/>
 *     &lt;xs:element type="xs:boolean" name="SpecialMarketed"/>
 *     &lt;xs:element type="xs:boolean" name="WaitList"/>
 *     &lt;xs:element type="xs:boolean" name="SpaceAvailable"/>
 *     &lt;xs:element type="xs:boolean" name="PositiveSpace"/>
 *     &lt;xs:element type="xs:int" name="PromotionCatID"/>
 *     &lt;xs:element type="xs:decimal" name="CommissionAmount"/>
 *     &lt;xs:element type="xs:decimal" name="PromotionAmount"/>
 *     &lt;xs:element type="ns:ArrayOfApplicableTaxDetail" nillable="true" name="ApplicableTaxDetails"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BaseFareInfo
{
    private int fareID;
    private String FCCode;
    private String FBCode;
    private BigDecimal baseFareAmtNoTaxes;
    private BigDecimal baseFareAmt;
    private BigDecimal fareAmtNoTaxes;
    private BigDecimal fareAmt;
    private BigDecimal baseFareAmtInclTax;
    private BigDecimal fareAmtInclTax;
    private boolean pvtFare;
    private int PTCID;
    private String cabin;
    private int seatsAvailable;
    private int infantSeatsAvailable;
    private int fareScheduleID;
    private int promotionID;
    private int roundTrip;
    private BigDecimal displayFareAmt;
    private BigDecimal displayTaxSum;
    private boolean specialMarketed;
    private boolean waitList;
    private boolean spaceAvailable;
    private boolean positiveSpace;
    private int promotionCatID;
    private BigDecimal commissionAmount;
    private BigDecimal promotionAmount;
    private ArrayOfApplicableTaxDetail applicableTaxDetails;

    /** 
     * Get the 'FareID' element value.
     * 
     * @return value
     */
    public int getFareID() {
        return fareID;
    }

    /** 
     * Set the 'FareID' element value.
     * 
     * @param fareID
     */
    public void setFareID(int fareID) {
        this.fareID = fareID;
    }

    /** 
     * Get the 'FCCode' element value.
     * 
     * @return value
     */
    public String getFCCode() {
        return FCCode;
    }

    /** 
     * Set the 'FCCode' element value.
     * 
     * @param FCCode
     */
    public void setFCCode(String FCCode) {
        this.FCCode = FCCode;
    }

    /** 
     * Get the 'FBCode' element value.
     * 
     * @return value
     */
    public String getFBCode() {
        return FBCode;
    }

    /** 
     * Set the 'FBCode' element value.
     * 
     * @param FBCode
     */
    public void setFBCode(String FBCode) {
        this.FBCode = FBCode;
    }

    /** 
     * Get the 'BaseFareAmtNoTaxes' element value.
     * 
     * @return value
     */
    public BigDecimal getBaseFareAmtNoTaxes() {
        return baseFareAmtNoTaxes;
    }

    /** 
     * Set the 'BaseFareAmtNoTaxes' element value.
     * 
     * @param baseFareAmtNoTaxes
     */
    public void setBaseFareAmtNoTaxes(BigDecimal baseFareAmtNoTaxes) {
        this.baseFareAmtNoTaxes = baseFareAmtNoTaxes;
    }

    /** 
     * Get the 'BaseFareAmt' element value.
     * 
     * @return value
     */
    public BigDecimal getBaseFareAmt() {
        return baseFareAmt;
    }

    /** 
     * Set the 'BaseFareAmt' element value.
     * 
     * @param baseFareAmt
     */
    public void setBaseFareAmt(BigDecimal baseFareAmt) {
        this.baseFareAmt = baseFareAmt;
    }

    /** 
     * Get the 'FareAmtNoTaxes' element value.
     * 
     * @return value
     */
    public BigDecimal getFareAmtNoTaxes() {
        return fareAmtNoTaxes;
    }

    /** 
     * Set the 'FareAmtNoTaxes' element value.
     * 
     * @param fareAmtNoTaxes
     */
    public void setFareAmtNoTaxes(BigDecimal fareAmtNoTaxes) {
        this.fareAmtNoTaxes = fareAmtNoTaxes;
    }

    /** 
     * Get the 'FareAmt' element value.
     * 
     * @return value
     */
    public BigDecimal getFareAmt() {
        return fareAmt;
    }

    /** 
     * Set the 'FareAmt' element value.
     * 
     * @param fareAmt
     */
    public void setFareAmt(BigDecimal fareAmt) {
        this.fareAmt = fareAmt;
    }

    /** 
     * Get the 'BaseFareAmtInclTax' element value.
     * 
     * @return value
     */
    public BigDecimal getBaseFareAmtInclTax() {
        return baseFareAmtInclTax;
    }

    /** 
     * Set the 'BaseFareAmtInclTax' element value.
     * 
     * @param baseFareAmtInclTax
     */
    public void setBaseFareAmtInclTax(BigDecimal baseFareAmtInclTax) {
        this.baseFareAmtInclTax = baseFareAmtInclTax;
    }

    /** 
     * Get the 'FareAmtInclTax' element value.
     * 
     * @return value
     */
    public BigDecimal getFareAmtInclTax() {
        return fareAmtInclTax;
    }

    /** 
     * Set the 'FareAmtInclTax' element value.
     * 
     * @param fareAmtInclTax
     */
    public void setFareAmtInclTax(BigDecimal fareAmtInclTax) {
        this.fareAmtInclTax = fareAmtInclTax;
    }

    /** 
     * Get the 'PvtFare' element value.
     * 
     * @return value
     */
    public boolean isPvtFare() {
        return pvtFare;
    }

    /** 
     * Set the 'PvtFare' element value.
     * 
     * @param pvtFare
     */
    public void setPvtFare(boolean pvtFare) {
        this.pvtFare = pvtFare;
    }

    /** 
     * Get the 'PTCID' element value.
     * 
     * @return value
     */
    public int getPTCID() {
        return PTCID;
    }

    /** 
     * Set the 'PTCID' element value.
     * 
     * @param PTCID
     */
    public void setPTCID(int PTCID) {
        this.PTCID = PTCID;
    }

    /** 
     * Get the 'Cabin' element value.
     * 
     * @return value
     */
    public String getCabin() {
        return cabin;
    }

    /** 
     * Set the 'Cabin' element value.
     * 
     * @param cabin
     */
    public void setCabin(String cabin) {
        this.cabin = cabin;
    }

    /** 
     * Get the 'SeatsAvailable' element value.
     * 
     * @return value
     */
    public int getSeatsAvailable() {
        return seatsAvailable;
    }

    /** 
     * Set the 'SeatsAvailable' element value.
     * 
     * @param seatsAvailable
     */
    public void setSeatsAvailable(int seatsAvailable) {
        this.seatsAvailable = seatsAvailable;
    }

    /** 
     * Get the 'InfantSeatsAvailable' element value.
     * 
     * @return value
     */
    public int getInfantSeatsAvailable() {
        return infantSeatsAvailable;
    }

    /** 
     * Set the 'InfantSeatsAvailable' element value.
     * 
     * @param infantSeatsAvailable
     */
    public void setInfantSeatsAvailable(int infantSeatsAvailable) {
        this.infantSeatsAvailable = infantSeatsAvailable;
    }

    /** 
     * Get the 'FareScheduleID' element value.
     * 
     * @return value
     */
    public int getFareScheduleID() {
        return fareScheduleID;
    }

    /** 
     * Set the 'FareScheduleID' element value.
     * 
     * @param fareScheduleID
     */
    public void setFareScheduleID(int fareScheduleID) {
        this.fareScheduleID = fareScheduleID;
    }

    /** 
     * Get the 'PromotionID' element value.
     * 
     * @return value
     */
    public int getPromotionID() {
        return promotionID;
    }

    /** 
     * Set the 'PromotionID' element value.
     * 
     * @param promotionID
     */
    public void setPromotionID(int promotionID) {
        this.promotionID = promotionID;
    }

    /** 
     * Get the 'RoundTrip' element value.
     * 
     * @return value
     */
    public int getRoundTrip() {
        return roundTrip;
    }

    /** 
     * Set the 'RoundTrip' element value.
     * 
     * @param roundTrip
     */
    public void setRoundTrip(int roundTrip) {
        this.roundTrip = roundTrip;
    }

    /** 
     * Get the 'DisplayFareAmt' element value. 
    					Description: This amount if greater than zero is meant to represent the fare
    					amount plus the taxes that are marked with the 'Bundled' column
    					equaling 1 (True).
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getDisplayFareAmt() {
        return displayFareAmt;
    }

    /** 
     * Set the 'DisplayFareAmt' element value. 
    					Description: This amount if greater than zero is meant to represent the fare
    					amount plus the taxes that are marked with the 'Bundled' column
    					equaling 1 (True).
    				Constraints: Optional (Not Required).
    				
     * 
     * @param displayFareAmt
     */
    public void setDisplayFareAmt(BigDecimal displayFareAmt) {
        this.displayFareAmt = displayFareAmt;
    }

    /** 
     * Get the 'DisplayTaxSum' element value. 
    					Description: This amount if greater than zero is meant to represent the fare
    					amount plus the taxes that are marked with the 'Bundled' column
    					equaling 1 (True) minus any tax object that has the TaxType value
    					of 2.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getDisplayTaxSum() {
        return displayTaxSum;
    }

    /** 
     * Set the 'DisplayTaxSum' element value. 
    					Description: This amount if greater than zero is meant to represent the fare
    					amount plus the taxes that are marked with the 'Bundled' column
    					equaling 1 (True) minus any tax object that has the TaxType value
    					of 2.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param displayTaxSum
     */
    public void setDisplayTaxSum(BigDecimal displayTaxSum) {
        this.displayTaxSum = displayTaxSum;
    }

    /** 
     * Get the 'SpecialMarketed' element value. 
    					Description: This field is an indicator to the ConnetPoint consumer that the
    					given fare is marked as a Special Marketed fare.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public boolean isSpecialMarketed() {
        return specialMarketed;
    }

    /** 
     * Set the 'SpecialMarketed' element value. 
    					Description: This field is an indicator to the ConnetPoint consumer that the
    					given fare is marked as a Special Marketed fare.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param specialMarketed
     */
    public void setSpecialMarketed(boolean specialMarketed) {
        this.specialMarketed = specialMarketed;
    }

    /** 
     * Get the 'WaitList' element value. 
    					Description: This field is an indicator to the ConnetPoint consumer that the
    					given fare is marked as a Wait listed fare.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public boolean isWaitList() {
        return waitList;
    }

    /** 
     * Set the 'WaitList' element value. 
    					Description: This field is an indicator to the ConnetPoint consumer that the
    					given fare is marked as a Wait listed fare.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param waitList
     */
    public void setWaitList(boolean waitList) {
        this.waitList = waitList;
    }

    /** 
     * Get the 'SpaceAvailable' element value. 
    					Description: This field is an indicator to the ConnetPoint consumer that the
    					given fare is marked as a non revenue stand by fare.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public boolean isSpaceAvailable() {
        return spaceAvailable;
    }

    /** 
     * Set the 'SpaceAvailable' element value. 
    					Description: This field is an indicator to the ConnetPoint consumer that the
    					given fare is marked as a non revenue stand by fare.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param spaceAvailable
     */
    public void setSpaceAvailable(boolean spaceAvailable) {
        this.spaceAvailable = spaceAvailable;
    }

    /** 
     * Get the 'PositiveSpace' element value. 
    					Description: This field is an indicator to the ConnetPoint consumer that the
    					given fare is marked as a non revenue positive space fare.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public boolean isPositiveSpace() {
        return positiveSpace;
    }

    /** 
     * Set the 'PositiveSpace' element value. 
    					Description: This field is an indicator to the ConnetPoint consumer that the
    					given fare is marked as a non revenue positive space fare.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param positiveSpace
     */
    public void setPositiveSpace(boolean positiveSpace) {
        this.positiveSpace = positiveSpace;
    }

    /** 
     * Get the 'PromotionCatID' element value. 
    					<summary>The promotion category ID</summary>
    				
     * 
     * @return value
     */
    public int getPromotionCatID() {
        return promotionCatID;
    }

    /** 
     * Set the 'PromotionCatID' element value. 
    					<summary>The promotion category ID</summary>
    				
     * 
     * @param promotionCatID
     */
    public void setPromotionCatID(int promotionCatID) {
        this.promotionCatID = promotionCatID;
    }

    /** 
     * Get the 'CommissionAmount' element value.
     * 
     * @return value
     */
    public BigDecimal getCommissionAmount() {
        return commissionAmount;
    }

    /** 
     * Set the 'CommissionAmount' element value.
     * 
     * @param commissionAmount
     */
    public void setCommissionAmount(BigDecimal commissionAmount) {
        this.commissionAmount = commissionAmount;
    }

    /** 
     * Get the 'PromotionAmount' element value.
     * 
     * @return value
     */
    public BigDecimal getPromotionAmount() {
        return promotionAmount;
    }

    /** 
     * Set the 'PromotionAmount' element value.
     * 
     * @param promotionAmount
     */
    public void setPromotionAmount(BigDecimal promotionAmount) {
        this.promotionAmount = promotionAmount;
    }

    /** 
     * Get the 'ApplicableTaxDetails' element value.
     * 
     * @return value
     */
    public ArrayOfApplicableTaxDetail getApplicableTaxDetails() {
        return applicableTaxDetails;
    }

    /** 
     * Set the 'ApplicableTaxDetails' element value.
     * 
     * @param applicableTaxDetails
     */
    public void setApplicableTaxDetails(
            ArrayOfApplicableTaxDetail applicableTaxDetails) {
        this.applicableTaxDetails = applicableTaxDetails;
    }
}
