
package org.datacontract.schemas.radixx.connectpoint.pricing;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Pricing.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enums.FareFilterMethodType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="CombinabilityNestedRoundtripAllFares"/>
 *     &lt;xs:enumeration value="CombinabilityNestedRoundtripLowestFarePerDay"/>
 *     &lt;xs:enumeration value="CombinabilityNestedRoundtripLowestFarePerFareType"/>
 *     &lt;xs:enumeration value="CombinabilityNestedRoundtripLowestFarePerFlight"/>
 *     &lt;xs:enumeration value="CombinabilityNestedRoundtripOnlyAllFares"/>
 *     &lt;xs:enumeration value="CombinabilityNestedRoundtripOnlyLowestFarePerDay"/>
 *     &lt;xs:enumeration value="CombinabilityNestedRoundtripOnlyLowestFarePerFareType"/>
 *     &lt;xs:enumeration value="CombinabilityNestedRoundtripOnlyLowestFarePerFlight"/>
 *     &lt;xs:enumeration value="NoCombinabilityAllFares"/>
 *     &lt;xs:enumeration value="NoCombinabilityRoundtripLowestFarePerDay"/>
 *     &lt;xs:enumeration value="NoCombinabilityRoundtripLowestFarePerFareType"/>
 *     &lt;xs:enumeration value="NoCombinabilityRoundtripLowestFarePerFlight"/>
 *     &lt;xs:enumeration value="NoCombinabilityRoundtripOnlyAllFares"/>
 *     &lt;xs:enumeration value="NoCombinabilityRoundtripOnlyLowestFarePerDay"/>
 *     &lt;xs:enumeration value="NoCombinabilityRoundtripOnlyLowestFarePerFareType"/>
 *     &lt;xs:enumeration value="NoCombinabilityRoundtripOnlyLowestFarePerFlight"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumsFareFilterMethodType {
    /** 
     * 
    <summary>Combinability rules applied. Roundtrip fares are nested.
    All fares are returned.</summary>
    
     */
    COMBINABILITY_NESTED_ROUNDTRIP_ALL_FARES(
            "CombinabilityNestedRoundtripAllFares"), /** 
                                                      * 
                                                     <summary>&gt;Combinability rules applied. Roundtrip fares are
                                                     nested. Fares filtered to: Lowest fare per day.</summary>
                                                     
                                                      */
    COMBINABILITY_NESTED_ROUNDTRIP_LOWEST_FARE_PER_DAY(
            "CombinabilityNestedRoundtripLowestFarePerDay"), /** 
                                                              * 
                                                             <summary>Combinability rules applied. Roundtrip fares are nested.
                                                             Fares filtered to: Lowest fare per fare type.</summary>
                                                             
                                                              */
    COMBINABILITY_NESTED_ROUNDTRIP_LOWEST_FARE_PER_FARE_TYPE(
            "CombinabilityNestedRoundtripLowestFarePerFareType"), /** 
                                                                   * 
                                                                  <summary>Combinability rules applied. Roundtrip fares are nested.
                                                                  Fares filtered to: Lowest fare per flight.</summary>
                                                                  
                                                                   */
    COMBINABILITY_NESTED_ROUNDTRIP_LOWEST_FARE_PER_FLIGHT(
            "CombinabilityNestedRoundtripLowestFarePerFlight"), /** 
                                                                 * 
                                                                <summary>Combinability rules applied. Roundtrip fares are nested.
                                                                All roundtrip fares are returned. One way fares are excluded.</summary>
                                                                
                                                                 */
    COMBINABILITY_NESTED_ROUNDTRIP_ONLY_ALL_FARES(
            "CombinabilityNestedRoundtripOnlyAllFares"), /** 
                                                          * 
                                                         <summary>&gt;Combinability rules applied. Roundtrip fares are
                                                         nested. Fares filtered to: Lowest roundtrip fare per day. One way
                                                         fares are excluded.</summary>
                                                         
                                                          */
    COMBINABILITY_NESTED_ROUNDTRIP_ONLY_LOWEST_FARE_PER_DAY(
            "CombinabilityNestedRoundtripOnlyLowestFarePerDay"), /** 
                                                                  * 
                                                                 <summary>Combinability rules applied. Roundtrip fares are nested.
                                                                 Fares filtered to: Lowest roundtrip fare per fare type. One way
                                                                 fares are excluded.</summary>
                                                                 
                                                                  */
    COMBINABILITY_NESTED_ROUNDTRIP_ONLY_LOWEST_FARE_PER_FARE_TYPE(
            "CombinabilityNestedRoundtripOnlyLowestFarePerFareType"), /** 
                                                                       * 
                                                                      <summary>Combinability rules applied. Roundtrip fares are nested.
                                                                      Fares filtered to: Lowest roundtrip fare per flight. One way
                                                                      fares are excluded.</summary>
                                                                      
                                                                       */
    COMBINABILITY_NESTED_ROUNDTRIP_ONLY_LOWEST_FARE_PER_FLIGHT(
            "CombinabilityNestedRoundtripOnlyLowestFarePerFlight"), /** 
                                                                     * 
                                                                    <summary>No combinability rules applied. No fares are nested. All
                                                                    fares are returned.</summary>
                                                                    
                                                                     */
    NO_COMBINABILITY_ALL_FARES("NoCombinabilityAllFares"), /** 
                                                            * 
                                                           <summary>&gt;No combinability rules applied. No fares are nested.
                                                           Fares filtered to: Lowest fare per day.</summary>
                                                           
                                                            */
    NO_COMBINABILITY_ROUNDTRIP_LOWEST_FARE_PER_DAY(
            "NoCombinabilityRoundtripLowestFarePerDay"), /** 
                                                          * 
                                                         <summary>No combinability rules applied. No fares are nested.
                                                         Fares filtered to: Lowest fare per fare type.</summary>
                                                         
                                                          */
    NO_COMBINABILITY_ROUNDTRIP_LOWEST_FARE_PER_FARE_TYPE(
            "NoCombinabilityRoundtripLowestFarePerFareType"), /** 
                                                               * 
                                                              <summary>No combinability rules applied. No fares are nested.
                                                              Fares filtered to: Lowest fare per flight.</summary>
                                                              
                                                               */
    NO_COMBINABILITY_ROUNDTRIP_LOWEST_FARE_PER_FLIGHT(
            "NoCombinabilityRoundtripLowestFarePerFlight"), /** 
                                                             * 
                                                            <summary>No combinability rules applied. No fares are nested. All
                                                            roundtrip fares are returned. One way fares are excluded.</summary>
                                                            
                                                             */
    NO_COMBINABILITY_ROUNDTRIP_ONLY_ALL_FARES(
            "NoCombinabilityRoundtripOnlyAllFares"), /** 
                                                      * 
                                                     <summary>&gt;No combinability rules applied. No fares are nested.
                                                     Fares filtered to: Lowest roundtrip fare per day. One way fares
                                                     are excluded.</summary>
                                                     
                                                      */
    NO_COMBINABILITY_ROUNDTRIP_ONLY_LOWEST_FARE_PER_DAY(
            "NoCombinabilityRoundtripOnlyLowestFarePerDay"), /** 
                                                              * 
                                                             <summary>No combinability rules applied. No fares are nested.
                                                             Fares filtered to: Lowest roundtrip fare per fare type. One way
                                                             fares are excluded.</summary>
                                                             
                                                              */
    NO_COMBINABILITY_ROUNDTRIP_ONLY_LOWEST_FARE_PER_FARE_TYPE(
            "NoCombinabilityRoundtripOnlyLowestFarePerFareType"), /** 
                                                                   * 
                                                                  <summary>No combinability rules applied. No fares are nested.
                                                                  Fares filtered to: Lowest roundtrip fare per flight. One way
                                                                  fares are excluded.</summary>
                                                                  
                                                                   */
    NO_COMBINABILITY_ROUNDTRIP_ONLY_LOWEST_FARE_PER_FLIGHT(
            "NoCombinabilityRoundtripOnlyLowestFarePerFlight");
    private final String value;

    private EnumsFareFilterMethodType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumsFareFilterMethodType convert(String value) {
        for (EnumsFareFilterMethodType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
